package com.biz.crm.mdm.business.login.config.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author jerry7
 * 首页配置扩展
 */
@EqualsAndHashCode(callSuper = false)
@Data
@ApiModel(value = "IndexConfigExpand", description = "首页配置实体扩展")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`mdm_index_config_expand`", comment = "首页配置实体扩展")
@TableName("mdm_index_config_expand")
@Table(name = "`mdm_index_config_expand`")
public class IndexConfigExpand extends FileEntity {
  private static final long serialVersionUID = -6872634571079633768L;
  /**
   * 数据类型
   */
  @ApiModelProperty("数据类型")
  @Column(name = "data_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 数据类型 '")
  private String dataType;
  /**
   * 配置头表id
   */
  @ApiModelProperty("配置头标ID")
  @Column(name = "config_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 配置表头ID '")
  private String configId;
  /**
   * 描述
   */
  @ApiModelProperty("描述")
  @Column(name = "name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 描述 '")
  private String name;

}
