package com.biz.crm.mdm.business.login.config.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.login.config.dto.ParameterManageDto;
import com.biz.crm.mdm.business.login.config.entity.ParameterManage;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author jerry7
 * 系统登录相关配置接口
 */
public interface ParameterManageService {

  /**
   * 条件分页查询
   * @param pageable 分页参数
   * @param vo 分页查询条件
   * @return 分页数据
   */
  Page<ParameterManage> findByConditions(Pageable pageable, ParameterManageDto vo);

  /**
   * 批量删除
   * @param ids 主键列表
   */
  void deleteBatch(List<String> ids);

  /**
   * 新建配置
   * @param parameterManage 配置实体
   * @return 新建后的实体类
   */
  ParameterManage create(ParameterManage parameterManage);

  /**
   * 更新配置
   * @param parameterManage 配置实体
   * @return 更新后的实体类
   */
  ParameterManage update(ParameterManage parameterManage);

}
