/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.login.config.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.login.config.dto.IndexConfigDto;
import com.biz.crm.mdm.business.login.config.entity.IndexConfig;
import com.biz.crm.mdm.business.login.config.entity.IndexConfigExpand;
import com.biz.crm.mdm.business.login.config.event.IndexConfigEventListener;
import com.biz.crm.mdm.business.login.config.repository.IndexConfigExpandRepository;
import com.biz.crm.mdm.business.login.config.repository.IndexConfigRepository;
import com.biz.crm.mdm.business.login.config.service.IndexConfigService;
import com.biz.crm.mdm.business.login.config.vo.IndexConfigExpandVo;
import com.biz.crm.mdm.business.login.config.vo.IndexConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IndexConfigServiceImpl
implements IndexConfigService {
    @Autowired(required=false)
    private IndexConfigRepository indexConfigRepository;
    @Autowired(required=false)
    private IndexConfigExpandRepository indexConfigExpandRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    @Lazy
    private List<IndexConfigEventListener> eventListeners;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<IndexConfig> findByConditions(Pageable pageable, IndexConfigDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new IndexConfigDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<IndexConfig> byConditions = this.indexConfigRepository.findByConditions((Page<IndexConfig>)page, dto);
        List records = byConditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return byConditions;
        }
        List<String> ids = records.stream().map(UuidEntity::getId).collect(Collectors.toList());
        List<IndexConfigExpand> detailByIds = this.indexConfigExpandRepository.findDetailByIds(ids, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(detailByIds)) {
            return byConditions;
        }
        Map<String, List<IndexConfigExpand>> expandMap = detailByIds.stream().collect(Collectors.groupingBy(IndexConfigExpand::getConfigId));
        for (IndexConfig record : records) {
            String id = record.getId();
            List<IndexConfigExpand> indexConfigExpands = expandMap.get(id);
            record.setItems(indexConfigExpands);
        }
        return byConditions;
    }

    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.indexConfigRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.indexConfigRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<IndexConfig> indexConfigs = this.indexConfigRepository.findListByIds(ids);
        this.indexConfigRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        List oldObj = (List)this.nebulaToolkitService.copyCollectionByWhiteList(indexConfigs, IndexConfig.class, IndexConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.eventListeners.forEach(indexConfigEventListener -> indexConfigEventListener.onDelete(oldObj));
    }

    @Override
    public IndexConfig findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (IndexConfig)((Object)this.indexConfigRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public IndexConfig create(IndexConfig indexConfig) {
        Validate.notNull((Object)((Object)indexConfig), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)indexConfig.getId()), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        this.createValidate(indexConfig);
        indexConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        indexConfig.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        indexConfig.setCreateTime(new Date());
        indexConfig.setCreateName(this.loginUserService.getLoginAccountName());
        this.indexConfigRepository.save((Object)indexConfig);
        if (!CollectionUtils.isEmpty(indexConfig.getItems())) {
            for (IndexConfigExpand expand : indexConfig.getItems()) {
                expand.setConfigId(indexConfig.getId());
                expand.setTenantCode(TenantUtils.getTenantCode());
            }
            this.indexConfigExpandRepository.saveBatch(indexConfig.getItems());
        }
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return indexConfig;
        }
        IndexConfigVo newObj = (IndexConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)indexConfig, IndexConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
        newObj.setItems((List)this.nebulaToolkitService.copyCollectionByWhiteList(indexConfig.getItems(), IndexConfigExpand.class, IndexConfigExpandVo.class, HashSet.class, ArrayList.class, new String[0]));
        this.eventListeners.forEach(indexConfigEventListener -> indexConfigEventListener.onCreate(newObj));
        return indexConfig;
    }

    @Override
    @Transactional
    public IndexConfig update(IndexConfig indexConfig) {
        Validate.notNull((Object)((Object)indexConfig), (String)"\u66f4\u65b0\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)indexConfig.getId(), (String)"\u767b\u5f55\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createValidate(indexConfig);
        IndexConfig entity = (IndexConfig)((Object)this.indexConfigRepository.getById((Serializable)((Object)indexConfig.getId())));
        IndexConfigVo oldObj = (IndexConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, IndexConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<IndexConfigExpand> indexConfigExpands = this.indexConfigExpandRepository.findDetailByIds(Collections.singletonList(indexConfig.getId()), indexConfig.getTenantCode());
        List indexConfigExpandVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(indexConfigExpands, IndexConfigExpand.class, IndexConfigExpandVo.class, HashSet.class, ArrayList.class, new String[0]);
        oldObj.setItems(indexConfigExpandVos);
        this.indexConfigRepository.saveOrUpdate((Object)indexConfig);
        this.indexConfigExpandRepository.deleteExpandByConfId(indexConfig.getId());
        if (!CollectionUtils.isEmpty(indexConfig.getItems())) {
            for (IndexConfigExpand expand : indexConfig.getItems()) {
                expand.setConfigId(indexConfig.getId());
                expand.setTenantCode(TenantUtils.getTenantCode());
            }
            this.indexConfigExpandRepository.saveBatch(indexConfig.getItems());
        }
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return indexConfig;
        }
        IndexConfigVo newObj = (IndexConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)indexConfig, IndexConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
        newObj.setItems((List)this.nebulaToolkitService.copyCollectionByWhiteList(indexConfig.getItems(), IndexConfigExpand.class, IndexConfigExpandVo.class, HashSet.class, ArrayList.class, new String[0]));
        this.eventListeners.forEach(indexConfigEventListener -> indexConfigEventListener.onUpdate(oldObj, newObj));
        return indexConfig;
    }

    private void createValidate(IndexConfig indexConfig) {
        indexConfig.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)indexConfig.getDataType(), (String)"\u767b\u5f55\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<IndexConfig> existList = this.indexConfigRepository.findByDataType(indexConfig.getDataType(), indexConfig.getTenantCode());
        Map existMap = existList.stream().filter(o -> !o.getId().equals(indexConfig.getId())).collect(Collectors.toMap(IndexConfig::getDataType, Function.identity()));
        IndexConfig exist = (IndexConfig)((Object)existMap.get(indexConfig.getDataType()));
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)exist)), (String)"\u8be5\u7c7b\u578b\u914d\u7f6e\u5df2\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)indexConfig.getTemplateName(), (String)"\u767b\u5f55\u914d\u7f6e\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)indexConfig.getIndexTitle(), (String)"\u767b\u5f55\u914d\u7f6e\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)indexConfig.getCompanyName(), (String)"\u767b\u5f55\u914d\u7f6e\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        indexConfig.getItems().forEach(o -> Validate.notBlank((CharSequence)o.getFileCode(), (String)"\u8f6e\u64ad\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
    }
}

