/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.login.config.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.login.config.dto.IndexConfigDto;
import com.biz.crm.mdm.business.login.config.entity.IndexConfig;
import com.biz.crm.mdm.business.login.config.mapper.IndexConfigMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IndexConfigRepository
extends ServiceImpl<IndexConfigMapper, IndexConfig> {
    public Page<IndexConfig> findByConditions(Page<IndexConfig> pageable, IndexConfigDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((IndexConfigMapper)this.baseMapper).findByConditions(pageable, dto);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"del_flag", (Object)delFlagStatusEnum.getCode());
        updateWrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<IndexConfig> findByDataType(String dataType, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(IndexConfig::getDataType, (Object)dataType)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }
}

