package com.biz.crm.mdm.business.login.config.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.login.config.deprecated.resp.LoginTypeControlVo;
import com.biz.crm.mdm.business.login.config.service.LoginConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author jerry7
 * 获取登录登出的系统参数
 */
@RestController
@RequestMapping("v1/loginConfig/loginConfig")
@Api(tags = "登录登出-系统参数获取")
public class LoginConfigController {

  @Autowired(required = false)
  private LoginConfigService systemLoginService;

  @ApiOperation("获取登录方式的控制参数")
  @PostMapping("/getSystemLoginTypeDefault")
  public Result<LoginTypeControlVo> getSystemLoginTypeDefault() {
    return Result.ok(systemLoginService.getSystemLoginTypeDefault());
  }

}
