package com.biz.crm.mdm.business.login.config.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.Table;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * @author hejun
 * @title PersonalizedTheme
 * @date 2023/2/13 13:59
 * @description 个性化主题
 */
@Data
@Entity
@Table(appliesTo = "personalized_theme",comment = "个性化主题")
@TableName("personalized_theme")
@ApiModel(value = "PersonalizedTheme",description = "个性化主题")
public class PersonalizedTheme extends TenantFlagOpEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty("系统主题编码")
  @TableField(value = "theme_code")
  @Column(name = "theme_code",length = 64 ,columnDefinition = "varchar(64) COMMENT '系统主题编码'")
  private String themeCode;

  @ApiModelProperty("系统主题名称")
  @TableField(value = "theme_name")
  @Column(name = "theme_name",length = 64 ,columnDefinition = "varchar(64) COMMENT '系统主题名称'")
  private String themeName;

  @ApiModelProperty("是否默认系统主题 true:是, false:否")
  @TableField(value = "default_theme")
  @Column(name = "default_theme", columnDefinition = "int COMMENT '是否默认系统主题 true:是, false:否'")
  private Boolean defaultTheme = false;

  @ApiModelProperty("菜单栏背景颜色")
  @TableField(value = "menu_background_color")
  @Column(name = "menu_background_color",length = 100 ,columnDefinition = "varchar(100) COMMENT '菜单栏背景颜色'")
  private String menuBackgroundColor;

  @ApiModelProperty("菜单栏选中")
  @TableField(value = "menu_select_color")
  @Column(name = "menu_select_color",length = 100 ,columnDefinition = "varchar(100) COMMENT '菜单栏选中'")
  private String menuSelectColor;

  @ApiModelProperty("菜单栏文字")
  @TableField(value = "menu_text_color")
  @Column(name = "menu_text_color",length = 100 ,columnDefinition = "varchar(100) COMMENT '菜单栏文字'")
  private String menuTextColor;

  @ApiModelProperty("表单选中色")
  @TableField(value = "form_select_color")
  @Column(name = "form_select_color",length = 100 ,columnDefinition = "varchar(100) COMMENT '表单选中色'")
  private String formSelectColor;

  @ApiModelProperty("链接颜色")
  @TableField(value = "url_color")
  @Column(name = "url_color",length = 100 ,columnDefinition = "varchar(100) COMMENT '链接颜色'")
  private String urlColor;

  /**
   * 颜色主体 dataJson
   */
  @ApiModelProperty("颜色主体_dataJson")
  @Column(name = "data_json", columnDefinition = "text COMMENT '颜色主体_dataJson'")
  private String dataJson;

}
