package com.biz.crm.mdm.business.login.config.event;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.login.config.vo.IndexConfigVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2023/1/29 11:09
 * @ClassName IndexConfigLogEventListenerImpl
 * @Description TODO  登录页配置 事件监听
 */
@Component
public class IndexConfigLogEventListenerImpl implements IndexConfigEventListener {

  @Autowired(required = false)
  private CrmBusinessLogVoService crmBusinessLogVoService;

  /**
   * 登录页配置创建时触发
   *
   * @param vo 创建时的vo
   */
  @Override
  public void onCreate(IndexConfigVo vo) {
    String onlyKey = vo.getId();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(null);
    crmBusinessLogDto.setNewObject(vo);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  /**
   * 登录页配置修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  @Override
  public void onUpdate(IndexConfigVo oldVo, IndexConfigVo newVo) {
    String onlyKey = newVo.getId();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(oldVo);
    crmBusinessLogDto.setNewObject(newVo);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  /**
   * 登录页配置禁用时触发
   *
   * @param voList 禁用vo信息
   */
  @Override
  public void onDisable(List<IndexConfigVo> voList) {

  }

  /**
   * 登录页配置开启时触发
   *
   * @param voList vo信息
   */
  @Override
  public void onEnable(List<IndexConfigVo> voList) {

  }

  /**
   * 登录页配置删除时触发
   *
   * @param voList 删除vo信息
   */
  @Override
  public void onDelete(List<IndexConfigVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    voList.forEach(terminalUserVo -> {
      String onlyKey = terminalUserVo.getId();
      CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
      crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
      crmBusinessLogDto.setOnlyKey(onlyKey);
      crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setOldObject(terminalUserVo);
      crmBusinessLogDto.setNewObject(null);
      crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    });
  }
}
