package com.biz.crm.mdm.business.login.config.repository;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.login.config.dto.ParameterManageDto;
import com.biz.crm.mdm.business.login.config.entity.ParameterManage;
import com.biz.crm.mdm.business.login.config.mapper.ParameterManageMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 全局配置 的 数据库访问类 {@link com.biz.crm.mdm.business.login.config.entity.ParameterManage}
 *
 * @author jerry7
 */
@Component
public class ParameterManageRepository extends ServiceImpl<ParameterManageMapper, ParameterManage> {


  /**
   * 分页条件查询客户物料
   *
   * @param pageable 分页信息
   * @param dto      查询筛选条件
   * @return 分页数据
   */
  public Page<ParameterManage> findByConditions(Page<ParameterManage> pageable, ParameterManageDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.baseMapper.findByConditions(pageable, dto);
  }

  /**
   * 根据主键集合，修改 del_flag
   *
   * @param delFlagStatusEnum 删除标记
   * @param ids               主键id集合
   */
  public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    UpdateWrapper<ParameterManage> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("del_flag", delFlagStatusEnum.getCode());
    updateWrapper.eq("tenant_code", TenantUtils.getTenantCode());
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }

}
