package com.biz.crm.mdm.business.login.config.service;

import com.biz.crm.mdm.business.login.config.dto.PersonalizedThemeDto;
import com.biz.crm.mdm.business.login.config.vo.PersonalizedThemeVo;

import java.util.List;

/**
 * @author hejun
 * @title PersonalizedThemeService
 * @date 2023/2/13 14:46
 * @description
 */
public interface PersonalizedThemeService {

  /**
   * 根据租户获取主题配置信息
   * @param dto
   * @return
   */
  List<PersonalizedThemeVo> findThemeByTenantCode(PersonalizedThemeDto dto);

  /**
   * 新增
   * @param dto
   * @return
   */
  PersonalizedThemeVo create(PersonalizedThemeDto dto);

  /**
   * 修改
   * @param dto
   * @return
   */
  PersonalizedThemeVo update(PersonalizedThemeDto dto);

  /**
   * 详情
   * @param id
   * @return
   */
  PersonalizedThemeVo findDetailById(String id);

  /**
   * 根据code 查询详情
   * @param code
   * @return
   */
  PersonalizedThemeVo findDetailByCode(String code);

  /**
   * 逻辑删除
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

}
