package com.biz.crm.mdm.business.login.config.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.login.config.dto.ParameterManageDto;
import com.biz.crm.mdm.business.login.config.entity.ParameterManage;
import com.biz.crm.mdm.business.login.config.repository.ParameterManageRepository;
import com.biz.crm.mdm.business.login.config.service.ParameterManageService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * @author jerry7
 * 登录配置service实现
 */
@Service
public class ParameterManageServiceImpl implements ParameterManageService {

  @Autowired(required = false)
  private ParameterManageRepository parameterManageRepository;

  @Override
  public Page<ParameterManage> findByConditions(Pageable pageable, ParameterManageDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new ParameterManageDto());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    Page<ParameterManage> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return parameterManageRepository.findByConditions(page, dto);
  }

  @Override
  public void deleteBatch(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "待修正的数据主键不能为空");
    parameterManageRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
  }

  @Override
  public ParameterManage create(ParameterManage parameterManage) {
    Validate.notNull(parameterManage, "创建全局参数对象不能为空");
    Validate.isTrue(StringUtils.isBlank(parameterManage.getId()), "创建全局参数id必须为空");
    this.verify(parameterManage);
    parameterManage.setTenantCode(TenantUtils.getTenantCode());   //新增租户编号
    this.parameterManageRepository.save(parameterManage);
    return parameterManage;
  }

  @Override
  public ParameterManage update(ParameterManage parameterManage) {
    Validate.notNull(parameterManage, "更新全局参数对象不能为空");
    Validate.notBlank(parameterManage.getId(), "更新全局参数id不能为空");
    this.verify(parameterManage);
    parameterManage.setTenantCode(TenantUtils.getTenantCode());   //新增租户编号
    this.parameterManageRepository.saveOrUpdate(parameterManage);
    return parameterManage;
  }

  private void verify(ParameterManage reqVo) {
    Assert.hasText(reqVo.getParameterCode(), "参数不能为空");
    Assert.hasText(reqVo.getParameterName(), "参数名称不能为空");
    Assert.hasText(reqVo.getDefaultValue(), "默认值不能为空");
    Assert.hasText(reqVo.getParameterValue(), "参数值不能为空");
  }
}
