/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.login.config.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.login.config.dto.PersonalizedThemeDto;
import com.biz.crm.mdm.business.login.config.service.PersonalizedThemeService;
import com.biz.crm.mdm.business.login.config.vo.PersonalizedThemeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/indexConfig/personalizedTheme"})
@Api(tags={"\u4e2a\u6027\u5316\u4e3b\u9898 : PersonalizedTheme : \u4e2a\u6027\u5316\u4e3b\u9898"})
public class PersonalizedThemeController {
    private static final Logger log = LoggerFactory.getLogger(PersonalizedThemeController.class);
    @Autowired(required=false)
    private PersonalizedThemeService personalizedThemeService;

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u540d\u79f0\u83b7\u53d6\u4e3b\u9898\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/findThemeByTenantCode"})
    public Result<List<PersonalizedThemeVo>> findThemeByTenantCode(PersonalizedThemeDto dto) {
        try {
            List<PersonalizedThemeVo> result = this.personalizedThemeService.findThemeByTenantCode(dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<PersonalizedThemeVo> create(@RequestBody PersonalizedThemeDto dto) {
        try {
            PersonalizedThemeVo current = this.personalizedThemeService.create(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<PersonalizedThemeVo> update(@RequestBody PersonalizedThemeDto dto) {
        try {
            PersonalizedThemeVo current = this.personalizedThemeService.update(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<PersonalizedThemeVo> findDetailById(@RequestParam String id) {
        try {
            PersonalizedThemeVo vo = this.personalizedThemeService.findDetailById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestBody List<String> ids) {
        try {
            this.personalizedThemeService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

