/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.login.config.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.login.config.dto.ParameterManageDto;
import com.biz.crm.mdm.business.login.config.entity.ParameterManage;
import com.biz.crm.mdm.business.login.config.repository.ParameterManageRepository;
import com.biz.crm.mdm.business.login.config.service.ParameterManageService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ParameterManageServiceImpl
implements ParameterManageService {
    @Autowired(required=false)
    private ParameterManageRepository parameterManageRepository;

    @Override
    public Page<ParameterManage> findByConditions(Pageable pageable, ParameterManageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ParameterManageDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.parameterManageRepository.findByConditions((Page<ParameterManage>)page, dto);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.parameterManageRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
    }

    @Override
    public ParameterManage create(ParameterManage parameterManage) {
        Validate.notNull((Object)((Object)parameterManage), (String)"\u521b\u5efa\u5168\u5c40\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)parameterManage.getId()), (String)"\u521b\u5efa\u5168\u5c40\u53c2\u6570id\u5fc5\u987b\u4e3a\u7a7a", (Object[])new Object[0]);
        this.verify(parameterManage);
        parameterManage.setTenantCode(TenantUtils.getTenantCode());
        this.parameterManageRepository.save((Object)parameterManage);
        return parameterManage;
    }

    @Override
    public ParameterManage update(ParameterManage parameterManage) {
        Validate.notNull((Object)((Object)parameterManage), (String)"\u66f4\u65b0\u5168\u5c40\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parameterManage.getId(), (String)"\u66f4\u65b0\u5168\u5c40\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.verify(parameterManage);
        parameterManage.setTenantCode(TenantUtils.getTenantCode());
        this.parameterManageRepository.saveOrUpdate((Object)parameterManage);
        return parameterManage;
    }

    private void verify(ParameterManage reqVo) {
        Assert.hasText((String)reqVo.getParameterCode(), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getParameterName(), (String)"\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDefaultValue(), (String)"\u9ed8\u8ba4\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getParameterValue(), (String)"\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

