/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.login.config.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.login.config.dto.PersonalizedThemeDto;
import com.biz.crm.mdm.business.login.config.entity.PersonalizedTheme;
import com.biz.crm.mdm.business.login.config.repository.PersonalizedThemeRepository;
import com.biz.crm.mdm.business.login.config.service.IndexConfigService;
import com.biz.crm.mdm.business.login.config.service.PersonalizedThemeService;
import com.biz.crm.mdm.business.login.config.vo.PersonalizedThemeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service(value="personalizedThemeService")
public class PersonalizedThemeServiceImpl
implements PersonalizedThemeService {
    @Autowired(required=false)
    private PersonalizedThemeRepository personalizedThemeRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private IndexConfigService indexConfigService;

    @Override
    public List<PersonalizedThemeVo> findThemeByTenantCode(PersonalizedThemeDto dto) {
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<PersonalizedTheme> defaultList = this.personalizedThemeRepository.findDefaultTheme(dto);
        List<PersonalizedTheme> userList = this.personalizedThemeRepository.findByTenantCode(dto);
        if (!ObjectUtils.isEmpty(userList)) {
            defaultList.addAll(userList);
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(defaultList, PersonalizedTheme.class, PersonalizedThemeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public PersonalizedThemeVo create(PersonalizedThemeDto dto) {
        this.validation(dto);
        String userName = this.loginUserService.getLoginAccountName();
        String tenantCode = TenantUtils.getTenantCode();
        PersonalizedTheme entity = (PersonalizedTheme)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, PersonalizedTheme.class, HashSet.class, ArrayList.class, new String[0]));
        if (StringUtils.isEmpty((CharSequence)entity.getThemeCode())) {
            String themeCode = (String)this.generateCodeService.generateCode("TC", 1).get(0);
            entity.setThemeCode(themeCode);
        } else {
            Integer count = this.personalizedThemeRepository.CountByThemeCode(entity.getThemeCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(entity.getThemeCode() + "\u7cfb\u7edf\u4e3b\u9898\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        entity.setDefaultTheme(false);
        entity.setCreateName(userName);
        entity.setCreateTime(new Date());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(tenantCode);
        this.personalizedThemeRepository.saveOrUpdate((Object)entity);
        return (PersonalizedThemeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, PersonalizedThemeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public PersonalizedThemeVo update(PersonalizedThemeDto dto) {
        this.validation(dto);
        String userName = this.loginUserService.getLoginAccountName();
        String tenantCode = TenantUtils.getTenantCode();
        PersonalizedTheme entity = (PersonalizedTheme)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, PersonalizedTheme.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setModifyName(userName);
        entity.setModifyTime(new Date());
        entity.setDefaultTheme(false);
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(tenantCode);
        PersonalizedTheme theme = this.personalizedThemeRepository.findById(entity.getId(), entity.getTenantCode());
        Validate.isTrue((!ObjectUtils.isEmpty((Object)((Object)theme)) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7cfb\u7edf\u4e3b\u9898\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((theme.getDefaultTheme() == false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u9ed8\u8ba4\u4e3b\u9898\u7981\u6b62\u4fee\u6539!", (Object[])new Object[0]);
        Validate.isTrue((boolean)theme.getThemeCode().equals(entity.getThemeCode()), (String)"\u7cfb\u7edf\u4e3b\u9898\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.personalizedThemeRepository.saveOrUpdate((Object)entity);
        return (PersonalizedThemeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, PersonalizedThemeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public PersonalizedThemeVo findDetailById(String id) {
        PersonalizedTheme entity = this.personalizedThemeRepository.findById(id, TenantUtils.getTenantCode());
        return (PersonalizedThemeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, PersonalizedThemeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public PersonalizedThemeVo findDetailByCode(String code) {
        PersonalizedTheme entity = this.personalizedThemeRepository.findByCode(code, TenantUtils.getTenantCode());
        return (PersonalizedThemeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, PersonalizedThemeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<PersonalizedTheme> themes = this.personalizedThemeRepository.findThemesByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(themes) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u5220\u9664\u7684\u4e3b\u9898\u914d\u7f6e!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        for (PersonalizedTheme item : themes) {
            Validate.isTrue((item.getDefaultTheme() == false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u9ed8\u8ba4\u4e3b\u9898\u914d\u7f6e\u7981\u6b62\u5220\u9664!", (Object[])new Object[0]);
            Validate.isTrue((boolean)tenantCode.equals(item.getTenantCode()), (String)"\u7981\u6b62\u5220\u9664\u975e\u5f53\u524d\u79df\u6237\u7684\u4e3b\u9898\u914d\u7f6e!", (Object[])new Object[0]);
            int count = this.indexConfigService.findIndexByThemeCode(item.getThemeCode());
            Validate.isTrue((count <= 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u914d\u8272\u6b63\u5728\u88ab\u4f7f\u7528, \u8bf7\u52ff\u5220\u9664", (Object[])new Object[0]);
            this.personalizedThemeRepository.removeById((Serializable)((Object)item.getId()));
        }
    }

    private void validation(PersonalizedThemeDto dto) {
        Validate.notNull((Object)dto, (String)"\u4e3b\u9898\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getThemeName()), (String)"\u7cfb\u7edf\u4e3b\u9898\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

