package com.biz.crm.mdm.business.login.config.event;

import com.biz.crm.mdm.business.login.config.vo.IndexConfigVo;
import java.util.List;
import com.biz.crm.mdm.business.login.config.dto.log.IndexConfigLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 
 * @author javadu
 * @describe:
 * @createTime 2023年02月10日 10:54:00
 */
public interface IndexConfigEventListener extends NebulaEvent {
    /**
     * 创建事件
     */
    void onCreate(IndexConfigLogEventDto eventDto);

    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(IndexConfigLogEventDto eventDto);

    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(IndexConfigLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(IndexConfigLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(IndexConfigLogEventDto eventDto);

  /**
   * 当首页配置创建时触发
   *
   * @param vo 创建时的vo
   */
  default void onCreate(IndexConfigVo vo) {
  }


  /**
   * 当首页配置修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  default void onUpdate(IndexConfigVo oldVo, IndexConfigVo newVo) {
  }


  /**
   * 当首页配置禁用时触发
   *
   * @param voList 禁用vo信息
   */
  default void onDisable(List<IndexConfigVo> voList) {
  }


  /**
   * 当首页配置启用时触发
   *
   * @param voList 禁用vo信息
   */
  default void onEnable(List<IndexConfigVo> voList) {
  }


  /**
   * 当首页配置删除时触发
   *
   * @param voList 删除vo信息
   */
  default void onDelete(List<IndexConfigVo> voList) {
  }
}
