package com.biz.crm.mdm.business.login.config.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;
/**
 * 首页配置实体主信息Vo
 * @author dutaotao
 * @date 2023-02-10 17:44:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "首页配置实体主信息Vo")
public class IndexConfigVo extends TenantFlagOpVo {
    /**
     * 类型
     */
    @ApiModelProperty("类型 1：后台，2小程序")
    private String dataType;
    /**
     * 模板名称
     */
    @ApiModelProperty("模板名称")
    private String templateName;
    /**
     * 登录页标题
     */
    @ApiModelProperty("登录页标题")
    private String indexTitle;
    /**
     * 服务热线
     */
    @ApiModelProperty("服务热线")
    private String servicePhone;
    /**
     * 客服电话
     */
    @ApiModelProperty("客服电话")
    private String clientPhone;
    /**
     * 备案号
     */
    @ApiModelProperty("备案号")
    private String recordNo;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String companyName;
    /**
     * 登录按钮颜色
     */
    @ApiModelProperty("登录按钮颜色")
    private String buttonColour;
    /**
     * 底部文字
     */
    @ApiModelProperty("底部文字")
    private String bottomText;
    /**
     * 首行企业logo图片
     */
    @ApiModelProperty("首页企业LOGO图片")
    private String logoUrl;

    @ApiModelProperty("长中部长轮播时间")
    private String logoTime;

    @ApiModelProperty("类型描述")
    private String dataTypeName;

    @ApiModelProperty("首页url地址")
    private String pcFirstUrl;

    /**
     * 后台logo图片
     */
    @ApiModelProperty("后台LOGO图片")
    private String backgroundLogoUrl;

    /**
     * dms小程序logo图片
     */
    @ApiModelProperty("dms小程序LOGO图片")
    private String dmsLogoUrl;

    @ApiModelProperty("扩展实体")
    private List<IndexConfigExpandVo> items;
}
