package com.biz.crm.mdm.business.login.config.event;

import com.biz.crm.mdm.business.login.config.vo.IndexConfigVo;

import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2023/1/29 10:58
 * @ClassName IndexConfigEventListener
 * @Description TODO
 */
public interface IndexConfigEventListener {

  /**
   * 当首页配置创建时触发
   *
   * @param vo 创建时的vo
   */
  default void onCreate(IndexConfigVo vo) {
  }


  /**
   * 当首页配置修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  default void onUpdate(IndexConfigVo oldVo, IndexConfigVo newVo) {
  }


  /**
   * 当首页配置禁用时触发
   *
   * @param voList 禁用vo信息
   */
  default void onDisable(List<IndexConfigVo> voList) {
  }


  /**
   * 当首页配置启用时触发
   *
   * @param voList 禁用vo信息
   */
  default void onEnable(List<IndexConfigVo> voList) {
  }


  /**
   * 当首页配置删除时触发
   *
   * @param voList 删除vo信息
   */
  default void onDelete(List<IndexConfigVo> voList) {
  }
}
