package com.biz.crm.mdm.business.login.config.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2023/1/29 11:01
 * @ClassName IndexConfigVo
 * @Description TODO
 */
@Data
public class IndexConfigVo extends TenantFlagOpVo {
    /**
     * 类型
     */
    @ApiModelProperty("类型 1：后台，2小程序")
    private String dataType;
    /**
     * 模板名称
     */
    @ApiModelProperty("模板名称")
    private String templateName;
    /**
     * 登录页标题
     */
    @ApiModelProperty("登录页标题")
    private String indexTitle;
    /**
     * 服务热线
     */
    @ApiModelProperty("服务热线")
    private String servicePhone;
    /**
     * 客服电话
     */
    @ApiModelProperty("客服电话")
    private String clientPhone;
    /**
     * 备案号
     */
    @ApiModelProperty("备案号")
    private String recordNo;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String companyName;
    /**
     * 登录按钮颜色
     */
    @ApiModelProperty("登录按钮颜色")
    private String buttonColour;
    /**
     * 底部文字
     */
    @ApiModelProperty("底部文字")
    private String bottomText;
    /**
     * 首行企业logo图片
     */
    @ApiModelProperty("首页企业LOGO图片")
    private String logoUrl;

    /**
     * 后台logo图片
     */
    @ApiModelProperty("后台LOGO图片")
    private String backgroundLogoUrl;

    /**
     * 后台LOGO小图片
     */
    @ApiModelProperty("后台LOGO小图片")
    private String backgroundSmallLogoUrl;

    /**
     * dms小程序logo图片
     */
    @ApiModelProperty("dms小程序LOGO图片")
    private String dmsLogoUrl;

    /**
     * 当前选择的主题配色编码
     */
    @ApiModelProperty("当前选择的主题配色编码")
    private String currentThemeCode;

    /**
     * 长中部长轮播时间
     */
    @ApiModelProperty("长中部长轮播时间")
    private String logoTime;

    @ApiModelProperty("扩展实体")
    private List<IndexConfigExpandVo> items;

    @ApiModelProperty("主题配色")
    private List<PersonalizedThemeVo> themeVoList;

    @ApiModelProperty("当前接口是否走新增:false 走编辑:true")
    private boolean updateFlag;
}
