package com.biz.crm.mdm.business.login.log.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.login.log.feign.feign.internal.LoginLogVoServiceFeignImpl;
import com.biz.crm.mdm.business.login.log.sdk.dto.LoginLogDto;
import com.biz.crm.mdm.business.login.log.sdk.vo.LoginLogVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 登录日志feign
 *
 * @author pengxi
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = LoginLogVoServiceFeignImpl.class)
public interface LoginLogVoServiceFeign {

  /**
   * 根据ID查询
   *
   * @param id 主键
   * @return Result
   */
  @ApiOperation(value = "根据ID查询")
  @GetMapping("/v1/loginLog/loginLog/findById")
  public Result<LoginLogVo> findById(@RequestParam("id") @ApiParam("主键") String id);

  /**
   * 创建登录日志
   * @param loginLogDto 登录日志信息
   * @return Result
   */
  @ApiOperation(value = "创建登录日志")
  @PostMapping(value = "/v1/loginLog/loginLog")
  public Result create(@RequestBody @ApiParam(name = "loginLogDto", value = "创建登录日志") LoginLogDto loginLogDto);

  @ApiOperation(value = "创建登录日志")
  @GetMapping(value = "/v1/loginLog/loginLog/findByAccount")
  public Result<LoginLogVo> findByAccount(@RequestParam("account") @ApiParam("主键") String account);
}
