package com.biz.crm.mdm.business.login.log.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.login.log.feign.feign.LoginLogVoServiceFeign;
import com.biz.crm.mdm.business.login.log.sdk.dto.LoginLogDto;
import com.biz.crm.mdm.business.login.log.sdk.vo.LoginLogVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 登录日志feign熔断实现
 *
 * @author pengxi
 */
@Component
public class LoginLogVoServiceFeignImpl
    implements FallbackFactory<LoginLogVoServiceFeign> {

  @Override
  public LoginLogVoServiceFeign create(Throwable throwable) {
    return new LoginLogVoServiceFeign() {

      @Override
      public Result<LoginLogVo> findById(String id) {
        throw new UnsupportedOperationException("根据ID查询熔断");
      }

      @Override
      public Result create(LoginLogDto loginLogDto) {
        throw new UnsupportedOperationException("创建登录日志熔断");
      }

      @Override
      public Result findByAccount(String account) {
        throw new UnsupportedOperationException("根据用户账号查询日志熔断");
      }
    };
  }
}
