/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.login.log.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.login.log.local.entity.LoginLog;
import com.biz.crm.mdm.business.login.log.local.repository.LoginLogRepository;
import com.biz.crm.mdm.business.login.log.sdk.dto.LoginLogDto;
import com.biz.crm.mdm.business.login.log.sdk.service.LoginLogVoService;
import com.biz.crm.mdm.business.login.log.sdk.vo.LoginLogVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoginLogVoServiceImpl
implements LoginLogVoService {
    @Autowired(required=false)
    private LoginLogRepository loginLogRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public Page<LoginLogVo> findByConditions(Pageable pageable, LoginLogDto loginLogDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        loginLogDto = Optional.ofNullable(loginLogDto).orElse(new LoginLogDto());
        loginLogDto.setTenantCode(TenantUtils.getTenantCode());
        return this.loginLogRepository.findByConditions(pageable, loginLogDto);
    }

    public LoginLogVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        LoginLog loginLog = (LoginLog)((Object)this.loginLogRepository.getById((Serializable)((Object)id)));
        if (loginLog == null) {
            return null;
        }
        return (LoginLogVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)loginLog, LoginLogVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void create(LoginLogDto loginLogDto) {
        Validate.notNull((Object)loginLogDto.getLoginType(), (String)"\u767b\u5f55\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loginLogDto.getUsertype(), (String)"\u7528\u6237\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loginLogDto.getAccount(), (String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loginLogDto.getFullName(), (String)"\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        LoginLog loginLog = (LoginLog)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)loginLogDto, LoginLog.class, HashSet.class, ArrayList.class, new String[0]));
        loginLog.setTenantCode(TenantUtils.getTenantCode());
        loginLog.setLoginTime(new Date());
        this.loginLogRepository.save((Object)loginLog);
    }
}

