package com.biz.crm.mdm.business.login.log.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.login.log.sdk.dto.LoginLogDto;
import com.biz.crm.mdm.business.login.log.sdk.vo.LoginLogVo;
import org.springframework.data.domain.Pageable;

/**
 * 登录日志接口
 *
 * @author pengxi
 */
public interface LoginLogVoService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param loginLogDto
   * @return
   */
  Page<LoginLogVo> findByConditions(Pageable pageable, LoginLogDto loginLogDto);

  /**
   * 通过id查询详情
   *
   * @param id
   * @return
   */
  LoginLogVo findById(String id);

  /**
   * 创建登录日志
   * @param loginLogDto
   * @return
   */
  LoginLogVo create(LoginLogDto loginLogDto);
}

