package com.biz.crm.mdm.business.login.log.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.login.log.sdk.dto.LoginLogDto;
import com.biz.crm.mdm.business.login.log.sdk.service.LoginLogVoService;
import com.biz.crm.mdm.business.login.log.sdk.vo.LoginLogVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 登录日志控制器
 *
 * @author pengxi
 */

@Api(tags = "登录日志：LoginLogVo：与登录日志相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/loginLog/loginLog")
public class LoginLogVoController {

  @Autowired(required = false)
  private LoginLogVoService loginLogVoService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<LoginLogVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                   @ApiParam(name = "loginLogDto", value = "分页Dto") LoginLogDto loginLogDto) {
    try {
      Page<LoginLogVo> result = this.loginLogVoService.findByConditions(pageable, loginLogDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据ID查询
   *
   * @param id 主键
   */
  @ApiOperation(value = "根据ID查询")
  @GetMapping("/findById")
  public Result<LoginLogVo> findById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      LoginLogVo result = this.loginLogVoService.findById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建登录日志
   */
  @ApiOperation(value = "创建登录日志")
  @PostMapping(value = "")
  public Result<?> create(@RequestBody @ApiParam(name = "loginLogDto", value = "创建登录日志") LoginLogDto loginLogDto) {
    try {
      this.loginLogVoService.create(loginLogDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据账户查询")
  @GetMapping(value = "findByAccount")
  public Result<?> findByAccount(@RequestParam("account") @ApiParam("主键") String account) {
    try {
      LoginLogVo byAccount = this.loginLogVoService.findByAccount(account);
      return Result.ok(byAccount);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
