package com.biz.crm.mdm.business.login.log.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.login.log.local.entity.LoginLog;
import com.biz.crm.mdm.business.login.log.sdk.dto.LoginLogDto;
import com.biz.crm.mdm.business.login.log.sdk.vo.LoginLogVo;
import org.apache.ibatis.annotations.Param;

/**
 * 登录日志mybatis-plus接口类
 * @author pengxi
 */
public interface LoginLogMapper extends BaseMapper<LoginLog> {
  /**
   * 分页条件查询
   *
   * @param page
   * @param loginLogDto
   * @return
   */
  Page<LoginLogVo> findByConditions(Page<LoginLogVo> page, @Param("dto") LoginLogDto loginLogDto);

  LoginLog findByAccount(@Param("account") String account, @Param("tenantCode") String tenantCode);
}
