package com.biz.crm.mdm.business.login.log.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 登录日志创建dto
 * @author pengxi
 */
@Data
@ApiModel("登录日志创建dto")
public class LoginLogDto extends TenantDto {

  /**
   * 登录时间
   */
  @ApiModelProperty("登录时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date loginTime;

  /**
   * 业务系统类型
   */
  @ApiModelProperty("业务系统类型")
  private Integer appType;

  /**
   * 登录方式
   */
  @ApiModelProperty("登录方式")
  private Integer loginType;

  /**
   * 用户类别(u-企业用户，c-客户用户，terminal-终端用户，customer - 经销商用户)
   */
  @ApiModelProperty("用户类别(u-企业用户，c-客户用户，terminal-终端用户，customer - 经销商用户)")
  private String usertype;

  /**
   * 登录账号
   */
  @ApiModelProperty("登录账号")
  private String account;

  /**
   * 用户名称
   */
  @ApiModelProperty("用户名称")
  private String fullName;

}
