/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.login.config.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.login.config.dto.IndexConfigDto;
import com.biz.crm.mdm.business.login.config.entity.IndexConfig;
import com.biz.crm.mdm.business.login.config.entity.IndexConfigExpand;
import com.biz.crm.mdm.business.login.config.repository.IndexConfigExpandRepository;
import com.biz.crm.mdm.business.login.config.repository.IndexConfigRepository;
import com.biz.crm.mdm.business.login.config.service.IndexConfigService;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IndexConfigServiceImpl
implements IndexConfigService {
    @Autowired
    private IndexConfigRepository indexConfigRepository;
    @Autowired
    private IndexConfigExpandRepository indexConfigExpandRepository;

    @Override
    public Page<IndexConfig> findByConditions(Pageable pageable, IndexConfigDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new IndexConfigDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.indexConfigRepository.findByConditions((Page<IndexConfig>)page, dto);
    }

    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.indexConfigRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.indexConfigRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.indexConfigRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
    }

    @Override
    public IndexConfig findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (IndexConfig)((Object)this.indexConfigRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public IndexConfig create(IndexConfig indexConfig) {
        Validate.notNull((Object)((Object)indexConfig), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)indexConfig.getId()), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        this.createValidate(indexConfig);
        this.indexConfigRepository.save((Object)indexConfig);
        if (!CollectionUtils.isEmpty(indexConfig.getIndexConfigExpandList())) {
            for (IndexConfigExpand expand : indexConfig.getIndexConfigExpandList()) {
                expand.setConfigId(indexConfig.getId());
            }
            this.indexConfigExpandRepository.saveBatch(indexConfig.getIndexConfigExpandList());
        }
        return indexConfig;
    }

    @Override
    @Transactional
    public IndexConfig update(IndexConfig indexConfig) {
        Validate.notNull((Object)((Object)indexConfig), (String)"\u66f4\u65b0\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)indexConfig.getId(), (String)"\u767b\u5f55\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createValidate(indexConfig);
        this.indexConfigRepository.saveOrUpdate((Object)indexConfig);
        this.indexConfigExpandRepository.deleteExpandByConfId(indexConfig.getId());
        if (!CollectionUtils.isEmpty(indexConfig.getIndexConfigExpandList())) {
            for (IndexConfigExpand expand : indexConfig.getIndexConfigExpandList()) {
                expand.setConfigId(indexConfig.getId());
            }
            this.indexConfigExpandRepository.saveBatch(indexConfig.getIndexConfigExpandList());
        }
        return indexConfig;
    }

    private void createValidate(IndexConfig indexConfig) {
        Validate.notBlank((CharSequence)indexConfig.getDataType(), (String)"\u767b\u5f55\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)indexConfig.getTemplateName(), (String)"\u767b\u5f55\u914d\u7f6e\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)indexConfig.getIndexTitle(), (String)"\u767b\u5f55\u914d\u7f6e\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)indexConfig.getCompanyName(), (String)"\u767b\u5f55\u914d\u7f6e\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)indexConfig.getPcFirstUrl(), (String)"\u767b\u5f55\u914d\u7f6e\u9996\u9875URL\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

