package com.biz.crm.mdm.business.message.local.notifier;

import cn.hutool.core.util.RandomUtil;
import com.biz.crm.common.message.sdk.dto.SysMessageDto;
import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.enums.MessageBusinessType;
import com.biz.crm.common.message.sdk.enums.MessageHandlerEnum;
import com.biz.crm.common.message.sdk.enums.MessageRelateType;
import com.biz.crm.common.message.sdk.enums.MessageTypeEnum;
import com.biz.crm.common.message.sdk.service.SendMessageVoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 监听实现demo
 *
 * @author sunx
 * @date 2022/7/5
 */
@Component
public class DemoListenerImpl {

  @Autowired(required = false)
  private SendMessageVoService sendMessageVoService;

  /** 订单关闭 */
  public void closeOrder() {
    final SysMessageDto msg = new SysMessageDto();
    // 消息类型编码  CloseOrderMessageRegisterImpl -》code
    msg.setCode(MessageTypeEnum.CLOSE_ORDER.getDictCode());
    Map<String, List<SysMessageItemDto>> map = Maps.newHashMap();
    // 业务员信息
    List<SysMessageItemDto> userItems = Lists.newLinkedList();
    final SysMessageItemDto dto1 = new SysMessageItemDto();
    dto1.setBusinessCode("业务员编码" + RandomUtil.randomInt(1, 20));
    dto1.setBusinessType(MessageBusinessType.BACKGROUND.getDictCode());
    dto1.setRelateCode("订单编码" + RandomUtil.randomInt(1, 20));
    dto1.setRelateType(MessageRelateType.ORDER.getDictCode());
    Map<String, String> param1Map = Maps.newHashMap();
    param1Map.put("orderCode", dto1.getRelateCode());
    dto1.setParamsMap(param1Map);
    userItems.add(dto1);
    // k- CloseOrderUserMessageHandlerRegisterImpl->code
    map.put(MessageHandlerEnum.CLOSE_ORDER_USER.getDictCode(), userItems);

    // 客户用户
    List<SysMessageItemDto> customerItems = Lists.newLinkedList();
    final SysMessageItemDto dto2 = new SysMessageItemDto();
    dto2.setBusinessCode("客户用户编码" + RandomUtil.randomInt(1, 20));
    dto2.setBusinessType(MessageBusinessType.CUSTOMER.getDictCode());
    dto2.setRelateCode("订单编码" + RandomUtil.randomInt(1, 20));
    dto2.setRelateType(MessageRelateType.ORDER.getDictCode());
    Map<String, String> param2Map = Maps.newHashMap();
    param2Map.put("orderCode", dto2.getRelateCode());
    dto2.setParamsMap(param2Map);
    customerItems.add(dto2);
    // k- CloseOrderCustomerMessageHandlerRegisterImpl->code
    map.put(MessageHandlerEnum.CLOSE_ORDER_CUSTOMER.getDictCode(), customerItems);

    msg.setMap(map);

    // 发送系统消息
    this.sendMessageVoService.send(msg);
  }

  /** 10天未发货订单通知业务员 */
  public void deliveryDelay() {
    final SysMessageDto msg = new SysMessageDto();
    // 消息类型编码  DeliveryDelayMessageRegisterImpl -》code
    msg.setCode(MessageTypeEnum.DELIVERY_DELAY.getDictCode());
    Map<String, List<SysMessageItemDto>> map = Maps.newHashMap();
    // 业务员信息
    List<SysMessageItemDto> userItems = Lists.newLinkedList();
    final SysMessageItemDto dto1 = new SysMessageItemDto();
    dto1.setBusinessCode("admin");
    dto1.setBusinessType(MessageBusinessType.BACKGROUND.getDictCode());
    dto1.setRelateCode("订单编码" + RandomUtil.randomInt(1, 20));
    dto1.setRelateType(MessageRelateType.ORDER.getDictCode());
    Map<String, String> param1Map = Maps.newHashMap();
    param1Map.put("orderCode", dto1.getRelateCode());
    dto1.setParamsMap(param1Map);
    userItems.add(dto1);
    // k- DeliveryDelayUserMessageHandlerRegisterImpl->code
    map.put(MessageHandlerEnum.DELIVERY_DELAY_USER.getDictCode(), userItems);

    msg.setMap(map);

    // 发送系统消息
    this.sendMessageVoService.send(msg);
  }
}
