package com.biz.crm.mdm.business.message.local.register.handler;

import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.enums.MessageHandlerEnum;
import com.biz.crm.common.message.sdk.register.SystemMessageHandlerRegister;
import com.biz.crm.common.message.sdk.service.SystemMessageVoService;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 订单关闭通知关联客户用户
 *
 * @author sunx
 * @date 2022/7/4
 */
@Slf4j
@Component
public class CloseOrderCustomerMessageHandlerRegisterImpl implements SystemMessageHandlerRegister {

  @Autowired(required = false)
  private SystemMessageVoService systemMessageVoService;

  @Override
  public String getCode() {
    return MessageHandlerEnum.CLOSE_ORDER_CUSTOMER.getDictCode();
  }

  @Override
  public String getName() {
    return MessageHandlerEnum.CLOSE_ORDER_CUSTOMER.getValue();
  }

  @Override
  public String getNoticeDesc() {
    return "客户";
  }

  @Override
  public String getContent() {
    return "您的订单${orderCode}被驳回，请尽快处理。";
  }

  @Override
  public int getOrder() {
    return 1;
  }

  @Override
  @Transactional
  public void sendMessage(String messageCode, List<SysMessageItemDto> list) {
    this.systemMessageVoService.create(messageCode, list, this.getContent());
  }
}
