package com.biz.crm.mdm.business.news.notice.sdk.dto.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 范围信息Dto
 *
 * @author lww
 * @date 2022/5/12
 */
@Data
@ApiModel(value = "ScopeDto", description = "范围信息Dto")
public class ScopeDto {

  /**
   * 公告id
   */
  @ApiModelProperty("公告id")
  private String noticeId;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  private String scopeCode;

  /**
   * 是否包含(true: 包含,false:不包含)
   */
  @ApiModelProperty("是否包含(true: 包含,false:不包含)")
  private Boolean containFlag;

  /**
   * 范围类型(ORG:组织范围,CHANNEL:渠道范围,CUSTOMER:客户范围)
   */
  @ApiModelProperty("范围类型(ORG:组织范围,CHANNEL:渠道范围,CUSTOMER:客户范围)")
  private String scopeType;
}
