/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.mdm.business.org.local.entity.OrgPosition;
import com.biz.crm.mdm.business.org.local.mapper.OrgPositionMapper;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class OrgPositionRepository
extends ServiceImpl<OrgPositionMapper, OrgPosition> {
    public List<OrgPosition> findByPositionCode(String positionCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(OrgPosition::getPositionCode, (Object)positionCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<OrgPosition> findByPositionCodes(List<String> positionCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(OrgPosition::getPositionCode, positionCodes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public void deleteByPositionCode(String orgCode, String positionCode, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(OrgPosition::getOrgCode, (Object)orgCode)).eq(OrgPosition::getPositionCode, (Object)positionCode)).remove();
    }

    public void deleteByPositionCodes(List<String> positionCodes, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(OrgPosition::getPositionCode, positionCodes)).remove();
    }

    public OrgPosition findByPositionCodeAndOrgCode(String positionCode, String orgCode, String tenantCode) {
        return (OrgPosition)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(OrgPosition::getPositionCode, (Object)positionCode)).eq(OrgPosition::getOrgCode, (Object)orgCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public List<OrgPosition> findByOrgCodes(List<String> orgCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(OrgPosition::getOrgCode, orgCodes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public void removeRelationByOrgCodeAndPositionCodes(String orgCode, List<String> positionCodeList, String tenantCode) {
        Validate.notEmpty((CharSequence)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(positionCodeList) ? 1 : 0) != 0, (String)"\u9700\u8981\u5173\u8054\u7684\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(OrgPosition::getOrgCode, (Object)orgCode)).in(OrgPosition::getPositionCode, positionCodeList)).remove();
    }
}

