/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.mapper.OrgMapper;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class OrgRepository
extends ServiceImpl<OrgMapper, Org> {
    private static final Integer SIZE = 1000;

    public Org findDetailsById(String id) {
        return ((OrgMapper)this.baseMapper).findDetailsById(id, DelFlagStatusEnum.NORMAL);
    }

    public Org findByOrgCode(String orgCode, String tenantCode) {
        return ((OrgMapper)this.baseMapper).findByOrgCode(orgCode, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public Page<Org> findByConditions(Pageable pageable, OrgPaginationDto paginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((OrgMapper)this.baseMapper).findByConditions((Page<Org>)page, paginationDto, DelFlagStatusEnum.NORMAL);
    }

    public List<Org> findDetailsByIds(List<String> ids) {
        return ((OrgMapper)this.baseMapper).findDetailsByIds(ids, DelFlagStatusEnum.NORMAL);
    }

    public List<Org> findByOrgCodeLikeOrOrgNameLike(String orgCodeLikeorNameLike) {
        if (StringUtils.isEmpty((CharSequence)orgCodeLikeorNameLike)) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(StringUtils.isNotEmpty((CharSequence)orgCodeLikeorNameLike), Org::getOrgCode, (Object)orgCodeLikeorNameLike)).or()).like(StringUtils.isNotEmpty((CharSequence)orgCodeLikeorNameLike), Org::getOrgName, (Object)orgCodeLikeorNameLike);
        })).list();
    }

    public List<Org> findByOrgCodes(List<String> orgCodes, String tenantCode) {
        return ((OrgMapper)this.baseMapper).findByOrgCodes(orgCodes, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<Org> findByParentCodes(List<String> parentCodes, String tenantCode) {
        return ((OrgMapper)this.baseMapper).findByParentCodes(parentCodes, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<String> findChildrenOrgCodeByRuleCodes(List<String> ruleCodes, String tenantCode) {
        return ((OrgMapper)this.baseMapper).findChildrenOrgCodeByRuleCodes(ruleCodes, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<String> findRuleCodeByIds(List<String> ids) {
        List orgs = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(CollectionUtils.isNotEmpty(ids), UuidEntity::getId, ids)).select(new SFunction[]{TenantFlagTreeOpEntity::getRuleCode}).list();
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return null;
        }
        return orgs.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
    }

    public String findRuleCodeByOrgCode(String orgCode, String tenantCode) {
        Org org = (Org)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Org::getOrgCode, (Object)orgCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new SFunction[]{TenantFlagTreeOpEntity::getRuleCode}).one());
        if (Objects.isNull((Object)org)) {
            return null;
        }
        return org.getRuleCode();
    }

    public List<String> findRuleCodeByOrgCodes(List<String> orgCodes, String tenantCode) {
        LinkedList list = Lists.newLinkedList();
        for (List item : Lists.partition(orgCodes, (int)SIZE)) {
            List cur = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Org::getOrgCode, (Collection)item)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new SFunction[]{TenantFlagTreeOpEntity::getRuleCode}).list();
            if (CollectionUtils.isEmpty((Collection)cur)) continue;
            list.addAll(cur.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toSet()));
        }
        return list;
    }

    public List<String> findRuleCodeByOrgTypes(List<String> orgTypes, String tenantCode) {
        List orgs = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtils.isNotEmpty(orgTypes), Org::getOrgType, orgTypes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new SFunction[]{TenantFlagTreeOpEntity::getRuleCode}).list();
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return null;
        }
        return orgs.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
    }

    public void updateEnableStatusByOrgCodes(List<String> orgCodes, EnableStatusEnum enable, String tenantCode) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"org_code", orgCodes);
        updateWrapper.eq((Object)"tenant_code", (Object)tenantCode);
        this.update((Wrapper)updateWrapper);
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<Org> findByParentCode(String parentCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Org::getParentCode, (Object)parentCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<Org> findByParentCodeIsNull(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Org::getParentCode, (Object)"")).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public void updateRuleCodeAndLevelNumByOrgCode(String orgCode, String ruleCode, int levelNum, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(TenantFlagTreeOpEntity::getRuleCode, (Object)ruleCode)).set(TenantFlagTreeOpEntity::getLevelNum, (Object)levelNum)).eq(Org::getOrgCode, (Object)orgCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).update();
    }

    public List<Org> findByRuleCodesAndEnableStatus(List<String> ruleCodes, EnableStatusEnum enable, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Objects.nonNull(enable), UuidFlagOpEntity::getEnableStatus, (Object)(enable != null ? enable.getCode() : null))).in(TenantFlagTreeOpEntity::getRuleCode, ruleCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<Org> findChildrenByRuleCode(String ruleCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(TenantFlagTreeOpEntity::getRuleCode, (Object)ruleCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<Org> findChildrenByRuleCode(List<String> ruleCodes, String tenantCode) {
        return ((OrgMapper)this.baseMapper).findChildrenByRuleCodes(ruleCodes, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public Page<Org> findChildrenByRuleCodes(Pageable pageable, List<String> ruleCodes, String tenantCode) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((OrgMapper)this.baseMapper).findChildrenByRuleCodes((Page<Org>)page, ruleCodes, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<Org> findByConditions(OrgPaginationDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)dto.getEnableStatus()), UuidFlagOpEntity::getEnableStatus, (Object)dto.getEnableStatus())).eq(StringUtils.isNotBlank((CharSequence)dto.getOrgType()), Org::getOrgType, (Object)dto.getOrgType())).eq(StringUtils.isNotBlank((CharSequence)dto.getParentCode()), Org::getParentCode, (Object)dto.getParentCode())).like(StringUtils.isNotBlank((CharSequence)dto.getOrgCode()), Org::getOrgCode, (Object)dto.getOrgCode())).like(StringUtils.isNotBlank((CharSequence)dto.getOrgName()), Org::getOrgName, (Object)dto.getOrgName())).eq(TenantFlagOpEntity::getTenantCode, (Object)dto.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
    }

    public List<Org> findOrgCodeAndRuleCodeByEnableStatusOptAndOrgNameLike(String enableStatus, String name, String tenantCode) {
        List likeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).like(Org::getOrgName, (Object)name)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).select(new SFunction[]{Org::getOrgCode, TenantFlagTreeOpEntity::getRuleCode}).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        return likeList;
    }

    public List<LazyTreeVo> findOrgLazyTreeList(String enableStatus, Boolean topOnly, String parentCode, List<String> codeList, List<String> ruleCodeList, String excludeRuleCode, String tenantCode) {
        return ((OrgMapper)this.baseMapper).findOrgLazyTreeList(enableStatus, topOnly, parentCode, codeList, ruleCodeList, excludeRuleCode, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public void updateOrphanParentCodeNull(String tenantCode) {
        ((OrgMapper)this.baseMapper).updateOrphanParentCodeNull(tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<Org> findListWithoutParentCode(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(Org::getParentCode, (Object)"")).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Org findDetailsByCode(String orgCode, String tenantCode) {
        Validate.notBlank((CharSequence)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (Org)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(Org::getOrgCode, (Object)orgCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<Org> findChildrenListByParentCode(String parentCode, String tenantCode) {
        parentCode = Optional.ofNullable(parentCode).orElse("");
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(Org::getParentCode, (Object)parentCode)).list();
    }

    public void setParentCodeNull(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Org::getParentCode, null)).eq(UuidEntity::getId, (Object)id)).update();
    }

    public void setParentCodeAndRuleCodeNull(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Org::getParentCode, null)).set(TenantFlagTreeOpEntity::getRuleCode, (Object)"")).eq(UuidEntity::getId, (Object)id)).update();
    }

    public Org findAllByOrgCode(Org org) {
        return (Org)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Org::getOrgCode, (Object)org.getOrgCode())).one());
    }

    public Set<String> findByOrgQueryDto(OrgQueryDto dto) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)dto.getDelFlag())).like(StringUtils.isNotBlank((CharSequence)dto.getOrgName()), Org::getOrgName, (Object)dto.getOrgName())).select(new SFunction[]{Org::getOrgCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Sets.newHashSet();
        }
        return list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(Org::getOrgCode).collect(Collectors.toSet());
    }
}

