/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.repository.OrgRepository;
import com.biz.crm.mdm.business.org.sdk.service.OrgLazyTreeVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgLazyTreeVoServiceImpl
implements OrgLazyTreeVoService {
    @Autowired(required=false)
    private OrgRepository orgRepository;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

    public List<LazyTreeVo> findByTreeDto(TreeDto treeDto) {
        Org one;
        ArrayList<LazyTreeVo> list = new ArrayList<LazyTreeVo>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getExcludeCodeAndChildren()) && (one = this.orgRepository.findByOrgCode(treeDto.getExcludeCodeAndChildren(), TenantUtils.getTenantCode())) != null) {
            excludeRuleCode = one.getRuleCode();
        }
        if (!StringUtils.isEmpty((CharSequence)treeDto.getParentCode())) {
            List<LazyTreeVo> lazyTreeVos = this.orgRepository.findOrgLazyTreeList(treeDto.getEnableStatus(), null, treeDto.getParentCode(), null, null, excludeRuleCode, TenantUtils.getTenantCode());
            list.addAll(lazyTreeVos);
        } else if (!StringUtils.isEmpty((CharSequence)treeDto.getName())) {
            List<Org> likeList = this.orgRepository.findOrgCodeAndRuleCodeByEnableStatusOptAndOrgNameLike(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode());
            if (!CollectionUtils.isEmpty(likeList)) {
                TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
                Set parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(3, likeList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(this.orgRepository.findOrgLazyTreeList(treeDto.getEnableStatus(), null, null, null, new ArrayList<String>(parentRuleCodes), excludeRuleCode, TenantUtils.getTenantCode()));
            }
        } else {
            list.addAll(this.orgRepository.findOrgLazyTreeList(treeDto.getEnableStatus(), true, null, null, null, excludeRuleCode, TenantUtils.getTenantCode()));
        }
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(item -> item.setHasChild(Boolean.valueOf(BooleanEnum.TRUE.getNumStr().equalsIgnoreCase(String.valueOf(item.getHasChildFlag())))));
            return TreeUtil.generateLazyTreeByParentCode(list);
        }
        return new ArrayList<LazyTreeVo>();
    }
}

