/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.common.enums.OrgTypeEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgTreeVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgTreeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class OrgTreeVoServiceImpl
implements OrgTreeVoService {
    @Autowired(required=false)
    private OrgService orgService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<OrgTreeVo> findAllStruTree() {
        return this.findTree(new OrgPaginationDto());
    }

    public List<OrgTreeVo> findByOrgNameStruTree(String orgName, String enableStatus) {
        List<String> ruleCodes;
        ArrayList<OrgTreeVo> tree = new ArrayList<OrgTreeVo>();
        OrgPaginationDto dto = new OrgPaginationDto();
        dto.setOrgName(orgName);
        dto.setEnableStatus(enableStatus);
        List<Org> list = this.orgService.findByConditions(dto);
        if (CollectionUtils.isEmpty(list)) {
            return tree;
        }
        if (StringUtils.isNotBlank((CharSequence)orgName) && CollectionUtils.isNotEmpty(ruleCodes = list.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList()))) {
            list = this.orgService.findAllParentByRuleCodes(ruleCodes);
        }
        List collect = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Org.class, OrgTreeVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map orgTypeMap = OrgTypeEnum.GETMAP;
        if (orgTypeMap != null && orgTypeMap.size() > 0) {
            for (OrgTreeVo orgTreeVo : collect) {
                String orgType = orgTreeVo.getOrgType();
                if (!StringUtils.isNotBlank((CharSequence)orgType)) continue;
                orgTreeVo.setOrgTypeName((String)orgTypeMap.get(orgType));
            }
        }
        for (OrgTreeVo orgTreeVo : collect) {
            ArrayList<OrgTreeVo> children;
            if (StringUtils.isBlank((CharSequence)orgTreeVo.getParentCode())) {
                tree.add(orgTreeVo);
            }
            if ((children = orgTreeVo.getChildren()) == null) {
                children = new ArrayList<OrgTreeVo>();
            }
            for (OrgTreeVo orgTreeRespVo : collect) {
                if (!Objects.equals(orgTreeVo.getOrgCode(), orgTreeRespVo.getParentCode())) continue;
                children.add(orgTreeRespVo);
            }
            orgTreeVo.setChildren(children);
        }
        return tree;
    }

    public List<OrgTreeVo> findAllStruTreeByCondition(OrgPaginationDto orgPaginationDto) {
        return this.findTree(orgPaginationDto);
    }

    private List<OrgTreeVo> findTree(OrgPaginationDto orgPaginationDto) {
        List<Org> list = this.orgService.findByConditions(orgPaginationDto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List totalList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Org.class, OrgTreeVo.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList<OrgTreeVo> treeList = new ArrayList<OrgTreeVo>();
        ArrayList<Object> currentLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, OrgTreeVo> totalMap = totalList.stream().collect(Collectors.toMap(OrgTreeVo::getOrgCode, v -> v));
        for (OrgTreeVo item : totalList) {
            if (StringUtils.isBlank((CharSequence)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                currentLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (currentLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<OrgTreeVo> restTempList = new ArrayList<OrgTreeVo>();
            ArrayList<OrgTreeVo> curLevelTempList = new ArrayList<OrgTreeVo>();
            Set curLevelSet = currentLevelList.stream().map(OrgTreeVo::getOrgCode).collect(Collectors.toSet());
            HashMap curLevelChildrenMap = new HashMap();
            for (OrgTreeVo orgTreeVo : restList) {
                if (curLevelSet.contains(orgTreeVo.getParentCode())) {
                    curLevelTempList.add(orgTreeVo);
                    ArrayList<OrgTreeVo> childrenList = new ArrayList<OrgTreeVo>();
                    if (curLevelChildrenMap.containsKey(orgTreeVo.getParentCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(orgTreeVo.getParentCode()));
                    }
                    childrenList.add(orgTreeVo);
                    curLevelChildrenMap.put(orgTreeVo.getParentCode(), childrenList);
                    continue;
                }
                restTempList.add(orgTreeVo);
            }
            for (OrgTreeVo orgTreeVo : currentLevelList) {
                if (!curLevelChildrenMap.containsKey(orgTreeVo.getOrgCode())) continue;
                orgTreeVo.setChildren((List)curLevelChildrenMap.get(orgTreeVo.getOrgCode()));
            }
            currentLevelList.clear();
            currentLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }
}

