/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.repository.OrgRepository;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class OrgVoServiceImpl
implements OrgVoService {
    @Autowired(required=false)
    private OrgService orgService;
    @Autowired(required=false)
    private OrgRepository orgRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

    public Page<OrgVo> findByConditions(Pageable pageable, OrgPaginationDto paginationDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (paginationDto == null) {
            paginationDto = new OrgPaginationDto();
        }
        Page<Org> page = this.orgService.findByConditions(pageable, paginationDto);
        Page pageVo = new Page();
        if (Objects.isNull(page)) {
            return null;
        }
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)page.getRecords(), Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.build(vos);
            pageVo.setRecords(vos);
        }
        pageVo.setCurrent(page.getCurrent());
        pageVo.setPages(page.getPages());
        pageVo.setTotal(page.getTotal());
        return pageVo;
    }

    public OrgVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Org org = this.orgService.findDetailsById(id);
        if (Objects.isNull((Object)org)) {
            return null;
        }
        OrgVo vo = (OrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vo);
        return vo;
    }

    public OrgVo findByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return null;
        }
        Org org = this.orgService.findByOrgCode(orgCode);
        if (Objects.isNull((Object)org)) {
            return null;
        }
        OrgVo vo = (OrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vo);
        return vo;
    }

    public List<OrgVo> findDetailsByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<Org> orgs = this.orgService.findDetailsByIds(ids);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vos);
        return vos;
    }

    public List<OrgVo> findAllParentByOrgCode(String orgCode) {
        if (StringUtils.isNotEmpty((CharSequence)orgCode)) {
            List<Org> orgs = this.orgService.findAllParentByOrgCode(orgCode);
            if (CollectionUtils.isEmpty(orgs)) {
                return null;
            }
            List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.build(vos);
            return vos;
        }
        return null;
    }

    public List<OrgVo> findAllParentByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            List<Org> orgs = this.orgService.findAllParentByOrgCodes(orgCodes);
            if (CollectionUtils.isEmpty(orgs)) {
                return null;
            }
            List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.build(vos);
            return vos;
        }
        return null;
    }

    public Set<String> findByOrgQueryDto(OrgQueryDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getOrgName()})) {
            return Sets.newHashSet();
        }
        return this.orgRepository.findByOrgQueryDto(dto);
    }

    public List<OrgVo> findByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        List<Org> orgs = this.orgService.findByOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vos);
        return vos;
    }

    public List<OrgVo> findAllChildrenById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        List<Org> orgs = this.orgService.findAllChildrenById(id);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vos);
        return vos;
    }

    public List<OrgVo> findAllChildrenByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return null;
        }
        List<Org> orgs = this.orgService.findAllChildrenByOrgCode(orgCode);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vos);
        return vos;
    }

    public List<OrgVo> findAllChildrenByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        List<Org> orgs = this.orgService.findAllChildrenByOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<OrgVo> findAllChildrenByOrgTypes(List<String> orgTypes) {
        if (CollectionUtils.isEmpty(orgTypes)) {
            return null;
        }
        List<Org> orgs = this.orgService.findAllChildrenByOrgTypes(orgTypes);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Map<String, String> findByRelateOrgCodeQueryDto(RelateOrgCodeQueryDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getOrgCodeSet())) {
            return Maps.newHashMap();
        }
        dto.setSearchType(Optional.ofNullable(dto.getSearchType()).orElse(0));
        List<Org> orgList = this.orgRepository.findByOrgCodes(Lists.newArrayList((Iterable)dto.getOrgCodeSet()), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(orgList)) {
            return Maps.newHashMap();
        }
        if (dto.getSearchType() == 0) {
            return orgList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getOrgCode(), a.getRuleCode()})).collect(Collectors.toMap(Org::getOrgCode, TenantFlagTreeOpEntity::getRuleCode, (a, b) -> a));
        }
        List<String> ruleCodeList = orgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRuleCode())).map(TenantFlagTreeOpEntity::getRuleCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ruleCodeList)) {
            return Maps.newHashMap();
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        if (dto.getSearchType() > 0) {
            Set ruleCodeSet = treeRuleCodeStrategy.findParentRuleCodesByRuleCodesExcludeSelf(3, ruleCodeList);
            if (CollectionUtils.isEmpty((Collection)ruleCodeSet)) {
                ruleCodeSet = Sets.newHashSet();
            }
            ruleCodeSet.addAll(ruleCodeList);
            if (CollectionUtils.isNotEmpty((Collection)ruleCodeSet)) {
                List<Org> cur = this.orgRepository.findByRuleCodesAndEnableStatus(Lists.newLinkedList((Iterable)ruleCodeSet), null, TenantUtils.getTenantCode());
                if (CollectionUtils.isEmpty(cur)) {
                    return Maps.newHashMap();
                }
                return cur.stream().collect(Collectors.toMap(Org::getOrgCode, TenantFlagTreeOpEntity::getRuleCode, (a, b) -> a));
            }
        } else {
            List<Org> cur = this.orgRepository.findChildrenByRuleCode(ruleCodeList, TenantUtils.getTenantCode());
            if (CollectionUtils.isEmpty(cur)) {
                return Maps.newHashMap();
            }
            return cur.stream().collect(Collectors.toMap(Org::getOrgCode, TenantFlagTreeOpEntity::getRuleCode, (a, b) -> a));
        }
        return Maps.newHashMap();
    }

    private void build(OrgVo vo) {
        OrgVo parent = vo.getParent();
        if (parent != null) {
            vo.setParentName(parent.getOrgName());
        }
    }

    private void build(List<OrgVo> vos) {
        vos = vos.stream().map(item -> {
            this.build((OrgVo)item);
            return item;
        }).collect(Collectors.toList());
    }
}

