package com.biz.crm.mdm.business.org.local.authority;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @Author: heguanyun
 * @Date: 2022/4/6 17:46 description:按照当前组织配置展示规则
 */
@Component("orgScopeRegister")
public class OrgScopeRegister implements SelectScopeRegister {
  @Override
  public String scopeKey() {
    return "org_scope";
  }

  @Override
  public String selectName() {
    return "当前组织";
  }

  @Override
  public String controlKey() {
    return "org_tree";
  }

  @Override
  public String controlName() {
    return "组织选择树";
  }

  /**
   * 判断是否启用该校验
   *
   * @param loginDetails
   * @param scopeValues
   * @return
   */
  @Override
  public boolean matched(UserIdentity loginDetails, String[] scopeValues) {
    if (scopeValues == null || scopeValues.length == 0) {
      return false;
    }
    String identityType = loginDetails.getIdentityType();
    // 如果不是后台管理用户，就不按职位进行权限控制
    if (!StringUtils.equals(identityType, "u")) {
      return false;
    }
    AbstractCrmUserIdentity loginUserDetails = (AbstractCrmUserIdentity) loginDetails;
    //如果没有当前字段，就不进行权限控制
    if(!loginUserDetails.hasField("orgCode")) {
      return false;
    }
    Object orgCodeObject = loginUserDetails.invokeFieldValue("orgCode");
    if(orgCodeObject == null) {
      return false;
    }
    Set<String> scopeSet = new HashSet<>(Arrays.asList(scopeValues));
    return scopeSet.contains(orgCodeObject.toString());
  }
}
