package com.biz.crm.mdm.business.org.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.local.service.OrgPermissionService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPermissionDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author chuyi
 * @version 1.0
 * @description: TODO
 * @date 2023/6/26 9:55
 */
@Api(value = "企业组织配送权限")
@Slf4j
@RestController
@RequestMapping(value = {"/v1/org/permission"})
public class OrgPermissionController {
    @Autowired(required = false)
    private OrgPermissionService orgPermissionService;

    @ApiOperation(value = "新增企业组织配送权限")
    @PostMapping(value = "/create")
    public Result<?> create(@RequestBody OrgPermissionDto dto){
        try {
            this.orgPermissionService.create(dto);
            return Result.ok("操作成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "修改企业组织配送权限")
    @PatchMapping(value = "/update")
    public Result<?> update(@RequestBody OrgPermissionDto dto){
        try {
            this.orgPermissionService.update(dto);
            return Result.ok("操作成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "删除企业组织配送权限")
    @GetMapping("/delete")
    public Result<?> deleteById(@RequestBody List<String> ids){
        try {
            this.orgPermissionService.deleteByIds(ids);
            return Result.ok("操作成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "启用企业组织配送权限")
    @GetMapping("/enable")
    public Result<?> enable(@RequestBody List<String> ids){
        try {
            this.orgPermissionService.enable(ids);
            return Result.ok("操作成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "禁用企业组织配送权限")
    @GetMapping("/disable")
    public Result<?> disable(@RequestBody List<String> ids){
        try {
            this.orgPermissionService.disable(ids);
            return Result.ok("操作成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

}
