package com.biz.crm.mdm.business.org.local.controller;
/**
 * Created by Bao Hongbin on 2021-10-27 17:48.
 */

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.local.service.OrgPositionService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPositionBindDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm
 * @description: 组织职位控制器
 * @author: Bao Hongbin
 * @create: 2021-10-27 17:48
 **/
@Api(tags = "组织：OrgPositionVo：组织关联职位的相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/org/position")
public class OrgPositionVoController {
  @Autowired(required = false)
  private OrgPositionService orgPositionService;
  @Autowired(required = false)
  private OrgPositionVoService orgPositionVoService;

  /**
   * 关联组织和职位
   */
  @ApiOperation(value = "关联组织和职位")
  @PostMapping(value = "/bind")
  public Result<?> bindPosition(
      @RequestBody @ApiParam(name = "orgPositionBindDto",
          value = "关联组织和职位") OrgPositionBindDto orgPositionBindDto) {
    try {
      this.orgPositionService.bindPosition(orgPositionBindDto);
      return Result.ok("关联成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 删除组织和职位关联
   */
  @ApiOperation(value = "删除组织和职位关联")
  @DeleteMapping("/unbind")
  public Result<?> unbindPosition(@RequestParam("ids") List<String> ids) {
    try {
      this.orgPositionService.unbindPosition(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据职位查询组织信息
   *
   * @param positionCode 岗位编码
   * @return Result<OrgVo>
   */
  @ApiOperation(value = "根据职位查询组织信息")
  @PostMapping(value = "/findByPositionCode")
  public Result<OrgVo> findByPositionCode(@RequestParam("positionCode") String positionCode) {
    try {
      OrgVo orgVo = this.orgPositionVoService.findByPositionCode(positionCode);
      return Result.ok(orgVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据组织编码查询组织职位集合
   *
   * @param orgCodes 组织机构编码
   * @return 组织职位集合
   */
  @ApiOperation(value = "根据组织编码查询组织职位集合")
  @GetMapping(value = {"/findByOrgCodes"})
  public Result<List<OrgPositionVo>> findByOrgCodes(@RequestParam("orgCodes") List<String> orgCodes) {
    try {
      return Result.ok(this.orgPositionVoService.findByOrgCodes(orgCodes));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据职位集合查询组织编码集合
   *
   * @param positionCodes 职位集合
   * @return 组织职位关联信息集合
   */
  @ApiOperation(value = "根据职位集合查询组织编码集合")
  @GetMapping(value = {"/findByPositionCodes"})
  public Result<List<OrgPositionVo>> findByPositionCodes(@RequestParam("positionCodes") List<String> positionCodes) {
    try {
      return Result.ok(this.orgPositionVoService.findByPositionCodes(positionCodes));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
