package com.biz.crm.mdm.business.org.local.deprecated.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgParentChildrenRedisVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgRedisVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgReloadRedisVo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 组织表redis缓存数据查询请求接口类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@RestController
@RequestMapping("/mdmOrgRedisController")
@Deprecated
public class MdmOrgRedisController {

  @Autowired(required = false)
  private OrgService orgService;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 根据组织编码集合获取组织详情redis缓存数据
   *
   * @param orgCodeList 组织编码集合
   * @return
   */
  @PostMapping("/findRedisListByOrgCodeList")
  public Result<List<MdmOrgRedisVo>> findRedisListByOrgCodeList(@RequestBody List<String> orgCodeList) {
    try {
      List<MdmOrgRedisVo> vos = null;
      List<Org> list = orgService.findByOrgCodes(orgCodeList);
      if (CollectionUtils.isNotEmpty(list)) {
        vos = list.stream().map(item -> {
          MdmOrgRedisVo vo = this.nebulaToolkitService.copyObjectByBlankList(item, MdmOrgRedisVo.class, HashSet.class, ArrayList.class);
          if (Objects.nonNull(item.getParent())) {
            vo.setParentName(item.getParent().getOrgName());
          }
          return vo;
        }).collect(Collectors.toList());
      }
      return Result.ok(vos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据组织编码集合获取组织上级redis缓存数据
   *
   * @param orgCodeList 组织编码集合
   * @return
   */
  @PostMapping("/findRedisOrgParentListByCodeList")
  public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgParentListByCodeList(@RequestBody List<String> orgCodeList) {
    try {
      List<MdmOrgParentChildrenRedisVo> result = new ArrayList<>();
      List<Org> parents = orgService.findAllParentByOrgCodes(orgCodeList);
      if (CollectionUtils.isEmpty(parents)) {
        return Result.ok(result);
      }
      Set<String> parentCodes = parents.stream().filter(item -> StringUtils.isNotBlank(item.getParentCode())).map(Org::getParentCode).collect(Collectors.toSet());
      List<Org> parentNames = orgService.findByOrgCodes(Lists.newArrayList(parentCodes));
      Map<String, String> parentOrgCodeNameMap = new HashMap<>();
      if (CollectionUtils.isNotEmpty(parentNames)) {
        parentOrgCodeNameMap = parentNames.stream().collect(Collectors.toMap(Org::getOrgCode, Org::getOrgName));
      }
      Map<String, String> finalParentOrgCodeNameMap = parentOrgCodeNameMap;
      List<MdmOrgRedisVo> parentRedisVoList = parents.stream().map(item -> {
        MdmOrgRedisVo vo = this.nebulaToolkitService.copyObjectByBlankList(item, MdmOrgRedisVo.class, HashSet.class, ArrayList.class);
        if (StringUtils.isNotBlank(vo.getParentCode())) {
          if (finalParentOrgCodeNameMap.containsKey(vo.getParentCode())) {
            vo.setParentName(finalParentOrgCodeNameMap.get(vo.getParentCode()));
          }
        }
        return vo;
      }).collect(Collectors.toList());
      for (Org item : parents) {
        MdmOrgParentChildrenRedisVo redisVo = new MdmOrgParentChildrenRedisVo();
        redisVo.setOrgCode(item.getOrgCode());
        redisVo.setList(parentRedisVoList.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
        result.add(redisVo);
      }
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据组织编码集合获取组织下级redis缓存数据
   *
   * @param orgCodeList 组织编码集合
   * @return
   */
  @PostMapping("/findRedisOrgChildrenListByCodeList")
  public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgChildrenListByCodeList(@RequestBody List<String> orgCodeList) {
    try {
      List<MdmOrgParentChildrenRedisVo> result = new ArrayList<>();
      List<Org> children = orgService.findAllChildrenByOrgCodes(orgCodeList);
      if (CollectionUtils.isEmpty(children)) {
        return Result.ok(result);
      }
      List<MdmOrgRedisVo> vos = (List<MdmOrgRedisVo>) this.nebulaToolkitService.copyCollectionByWhiteList(children, Org.class, MdmOrgRedisVo.class, HashSet.class, ArrayList.class);
      for (Org item : children) {
        MdmOrgParentChildrenRedisVo redisVo = new MdmOrgParentChildrenRedisVo();
        redisVo.setOrgCode(item.getOrgCode());
        redisVo.setList(vos.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
        result.add(redisVo);
      }
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取全部组织redis缓存数据
   *
   * @return
   */
  @PostMapping("/findRedisReloadList")
  public Result<List<MdmOrgReloadRedisVo>> findRedisReloadList() {
    try {
      List<MdmOrgReloadRedisVo> vos = Lists.newArrayList();
      OrgPaginationDto paginationDto = new OrgPaginationDto();
      List<Org> all = orgService.findByConditions(paginationDto);
      if (CollectionUtils.isEmpty(all)) {
        return Result.ok(vos);
      }
      final Map<String, String> orgCodeNameMap = all.stream().collect(Collectors.toMap(Org::getOrgCode, Org::getOrgName));
      final List<MdmOrgRedisVo> redisList = all.stream().map(item -> {
        MdmOrgRedisVo copy = this.nebulaToolkitService.copyObjectByBlankList(item, MdmOrgRedisVo.class, HashSet.class, ArrayList.class);
        if (StringUtils.isNotEmpty(copy.getParentCode())) {
          copy.setParentName(orgCodeNameMap.get(copy.getParentCode()));
        }
        return copy;
      }).collect(Collectors.toList());
      vos = redisList.stream().map(item -> {
        MdmOrgReloadRedisVo redisVo = new MdmOrgReloadRedisVo();
        redisVo.setOrgCode(item.getOrgCode());
        redisVo.setSelf(item);
        redisVo.setParentList(redisList.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
        redisVo.setChildrenList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item.getRuleCode())).collect(Collectors.toList()));
        return redisVo;
      }).collect(Collectors.toList());
      return Result.ok(vos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
