package com.biz.crm.mdm.business.org.local.deprecated.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.local.entity.OrgRegion;
import com.biz.crm.mdm.business.org.local.service.OrgRegionService;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgRegionReqVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgRegionRespVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgRegionVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgRegionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 组织和行政区域关联表
 *
 * @author Tao.Chen
 * @date 2020-11-17 10:42:46
 */
@Slf4j
@RestController
@RequestMapping("/mdmOrgRegionController")
@Api(tags = "MDM-组织管理-关联行政区域")
@Deprecated
public class MdmOrgRegionController {

  @Autowired(required = false)
  private OrgRegionVoService orgRegionVoService;
  @Autowired(required = false)
  private OrgRegionService orgRegionService;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @ApiOperation(value = "查询组织关联的行政区域列表（不分页）")
  @PostMapping("/findOrgRegionList")
  public Result<List<MdmOrgRegionRespVo>> findOrgRegionList(@RequestBody MdmOrgRegionReqVo reqVo) {
    try {
      Validate.notBlank(reqVo.getOrgCode(), "orgCode不能为空");
      List<OrgRegionVo> list = this.orgRegionVoService.findByOrgCode(reqVo.getOrgCode());
      List<MdmOrgRegionRespVo> vos = null;
      if (CollectionUtils.isNotEmpty(list)) {
        vos = (List<MdmOrgRegionRespVo>) this.nebulaToolkitService.copyCollectionByBlankList(list, OrgRegionVo.class, MdmOrgRegionRespVo.class, HashSet.class, ArrayList.class);
      }
      return Result.ok(vos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增组织和行政区域关联关系")
  @PostMapping("/saveOrgRegion")
  public Result<?> saveOrgRegion(@RequestBody MdmOrgRegionReqVo reqVo) {
    try {
      if (Objects.isNull(reqVo) || CollectionUtils.isEmpty(reqVo.getRegionList())) {
        return Result.ok();
      }
      List<MdmOrgRegionReqVo> vos = reqVo.getRegionList();
      List<OrgRegion> list = (List<OrgRegion>) this.nebulaToolkitService.copyCollectionByBlankList(vos, MdmOrgRegionReqVo.class, OrgRegion.class, HashSet.class, ArrayList.class);
      this.orgRegionService.createBatch(list);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
