package com.biz.crm.mdm.business.org.local.deprecated.controller;

import com.biz.crm.business.common.sdk.deprecated.dto.BaseLazyTreeReqVo;
import com.biz.crm.business.common.sdk.deprecated.vo.BaseLazyTreeRespVo;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.org.local.controller.OrgLazyTreeVoController;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/**
 * hefan：
 *  注意：
 *  老crm把各个模块的都写到了一个controller。
 *  我们新的改造中，都写到各自的模块中，修改类名（防止bean冲突），Mapping中的值不要变（方便检索）。
 *
 * 懒加载树
 *
 * @author Tao.Chen
 * @date 2020-12-14 17:12:13
 */
@Deprecated
@RestController
@RequestMapping("/baseLazyTreeController")
@Api(tags = "公共树（懒加载）")
public class OrgBaseLazyTreeController {

    @Autowired(required = false)
    private OrgLazyTreeVoController orgLazyTreeVoController;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 组织懒加载树
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "组织懒加载树", notes = "什么都不传返回第一层，传parentCode返回这个编码的下一级，传name模糊查询并且查询出所有上级再构建成树形，优先级parentCode > name")
    @PostMapping("/orgLazyTree")
    public Result<List<BaseLazyTreeRespVo>> orgLazyTree(@RequestBody BaseLazyTreeReqVo reqVo) {
        TreeDto treeDto = this.nebulaToolkitService.copyObjectByBlankList(reqVo, TreeDto.class, HashSet.class, LinkedList.class);
        Result<List<LazyTreeVo>> result = orgLazyTreeVoController.findByTreeDto(treeDto);
        List<BaseLazyTreeRespVo> baseLazyTreeRespVos = (List<BaseLazyTreeRespVo>)this.nebulaToolkitService.copyCollectionByBlankList(result.getResult(), LazyTreeVo.class, BaseLazyTreeRespVo.class, HashSet.class, LinkedList.class);
        return Result.ok(baseLazyTreeRespVos);
    }


}
