package com.biz.crm.mdm.business.org.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 组织表实体类
 *
 * @author Tao.Chen hecheng
 * @date 2020-11-17 20:23:13  2021/09/26
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_org")
@Table(name = "mdm_org",
  indexes = {
        @Index(name = "mdm_org_index4", columnList = "tenant_code, del_flag, create_time")
  })
@ApiModel("组织表实体类")
@Entity
public class Org extends TenantFlagTreeOpEntity {
  private static final long serialVersionUID = 5898660422107473905L;

  /**
   * 组织编码
   */
  @TableField(value = "org_code")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @TableField(value = "org_name")
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 组织类型
   * --补充：层级名称
   */
  @TableField(value = "org_type")
  @ApiModelProperty("组织类型")
  private String orgType;

  /**
   * 组织描述
   */
  @TableField(value = "org_desc")
  @ApiModelProperty("组织描述")
  private String orgDesc;

  /**
   * 上级组织编码
   */
  @TableField(value = "parent_code")
  @ApiModelProperty("上级组织编码")
  private String parentCode;

  /**
   * 对应SAP组织编码
   */
  @TableField(value = "sap_org_code")
  @ApiModelProperty("对应SAP组织编码")
  private String sapOrgCode;

  /**
   * 对应SAP组织编码利润中心编码
   */
  @TableField(value = "sap_profit_org_code")
  @ApiModelProperty("对应SAP组织编码利润中心编码")
  private String sapProfitOrgCode;

  /**
   * 对应SAP组织编码成本中心编码
   */
  @TableField(value = "sap_cost_org_code")
  @ApiModelProperty("对应SAP组织编码成本中心编码")
  private String sapCostOrgCode;

  /**
   * 父节点
   */
  @TableField(exist = false)
  @Transient
  private Org parent;

  /**
   * 子节点
   */
  @ApiModelProperty("子节点")
  @TableField(exist = false)
  @Transient
  private List<Org> children;

  /**
   * 上级组织名称
   */
  @TableField(exist = false)
  @ApiModelProperty("上级组织名称")
  @Transient
  private String parentName;

  /**
   * 配送权限
   */
  @TableField(value = "authority")
  @ApiModelProperty("自配送权限")
  private String authority;
}
