package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.repository.OrgRepository;
import com.biz.crm.mdm.business.org.local.service.OrgPermissionService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPermissionDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @author chuyi
 * @version 1.0
 * @description: TODO
 * @date 2023/6/26 9:59
 */
@Service
public class OrgPermissionServiceImpl implements OrgPermissionService {
    @Autowired(required = false)
    private OrgRepository repository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void create(OrgPermissionDto dto) {
        this.createValidate(dto);
        Org org = this.createFrom(dto);
        this.repository.save(org);
    }

    private Org createFrom(OrgPermissionDto dto) {
        Org org = this.nebulaToolkitService.copyObjectByWhiteList(dto, Org.class, HashSet.class, ArrayList.class);
        org.setParentName(dto.getParentName());
        org.setOrgType(dto.getOrgType());
        org.setOrgCode(dto.getOrgCode());
        org.setAuthority(dto.getAuthority());
        org.setOrgName(dto.getOrgName());
        org.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        org.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        org.setTenantCode(TenantUtils.getTenantCode());
        Org entity = this.repository.findLevelNumByName(dto.getParentName());
        int levelNum=1;
        if (entity!=null){
            levelNum = entity.getLevelNum()+1;
            org.setParentCode(entity.getOrgCode());
        }
        org.setLevelNum(levelNum);
        return org;
    }

    @Override
    @Transactional
    public void update(OrgPermissionDto dto) {
       this.editValidate(dto);
        Org org = this.nebulaToolkitService.copyObjectByWhiteList(dto, Org.class, HashSet.class, ArrayList.class);
        this.repository.updateById(org);
    }

    @Override
    @Transactional
    public void deleteByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids),"id不能为空");
        this.repository.removeByIds(ids);
    }

    @Override
    @Transactional
    public void enable(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids),"id集合不能为空");
        this.repository.enableIds(ids);
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids),"id集合不能为空");
        this.repository.disable(ids);
    }

    private void editValidate(OrgPermissionDto dto) {
        Validate.notNull(dto,"请求参数不能为空");
        Validate.notBlank(dto.getId(),"请求id不能为空");
        Validate.notBlank(dto.getOrgCode(),"组织编码不能为空");
        Validate.notBlank(dto.getOrgType(),"组织层级不能为空");
        Validate.notBlank(dto.getOrgName(),"组织名称不能为空");
        Validate.notBlank(dto.getParentName(),"上级组织名称不能为空");
        Validate.notBlank(dto.getAuthority(),"组织配送权限不能为空");
    }

    private void createValidate(OrgPermissionDto dto) {
        Validate.notNull(dto,"请求参数不能为空");
        Validate.notBlank(dto.getOrgCode(),"组织编码不能为空");
        Validate.notBlank(dto.getOrgType(),"组织层级不能为空");
        Validate.notBlank(dto.getOrgName(),"组织名称不能为空");
        Validate.notBlank(dto.getParentName(),"上级组织名称不能为空");
        Validate.notBlank(dto.getAuthority(),"组织配送权限不能为空");

    }
}
