package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.mdm.business.org.local.entity.OrgRegion;
import com.biz.crm.mdm.business.org.local.service.OrgRegionService;
import com.biz.crm.mdm.business.org.sdk.service.OrgRegionVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgRegionVo;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * @author hecheng
 * @description: 组织区域vo service 实现
 * @date 2021/10/15 下午2:31
 */
@Service
public class OrgRegionVoServiceImpl implements OrgRegionVoService {

  @Autowired(required = false)
  private OrgRegionService orgRegionService;
  @Autowired(required = false)
  private RegionVoService regionVoService;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<OrgRegionVo> findByOrgCode(String orgCode) {
    if (StringUtils.isBlank(orgCode)) {
      return null;
    }
    List<OrgRegion> orgRegions = this.orgRegionService.findByOrgCode(orgCode);
    if (CollectionUtils.isEmpty(orgRegions)) {
      return null;
    }
    List<OrgRegionVo> vos = (List<OrgRegionVo>) this.nebulaToolkitService.copyCollectionByBlankList(orgRegions, OrgRegion.class, OrgRegionVo.class, HashSet.class, ArrayList.class);
    this.build(vos);
    return vos;
  }

  /**
   * 构建区域名称
   *
   * @param vos
   */
  private void build(List<OrgRegionVo> vos) {
    Stream<String> countryCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank(item.getCountryCode())).map(OrgRegionVo::getCountryCode);
    Stream<String> provinceCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank(item.getProvinceCode())).map(OrgRegionVo::getProvinceCode);
    Stream<String> cityCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank(item.getCityCode())).map(OrgRegionVo::getCityCode);
    Stream<String> districtCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank(item.getDistrictCode())).map(OrgRegionVo::getDistrictCode);
    Stream<String> townshipCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank(item.getTownshipCode())).map(OrgRegionVo::getTownshipCode);
    Set<String> regionCodes = Stream.of(countryCodeStream, provinceCodeStream, cityCodeStream, districtCodeStream, townshipCodeStream).
            flatMap(itemStream -> itemStream).collect(Collectors.toSet());
    Map<String, String> keyValue = this.regionVoService.findRegionCodeNameMap(Lists.newArrayList(regionCodes));
    if (Objects.isNull(keyValue)) {
      return;
    }
    vos = vos.stream().map(item -> {
      item.setCountryName(keyValue.get(item.getCountryCode()));
      item.setCityName(keyValue.get(item.getCityCode()));
      item.setProvinceName(keyValue.get(item.getProvinceCode()));
      item.setDistrictName(keyValue.get(item.getDistrictCode()));
      item.setTownshipName(keyValue.get(item.getTownshipCode()));
      return item;
    }).collect(Collectors.toList());
  }
}
