package com.biz.crm.mdm.business.org.local.service.notifier;
/**
 * Created by Bao Hongbin on 2021-12-02 19:45.
 */

import com.biz.crm.mdm.business.org.local.entity.OrgRegion;
import com.biz.crm.mdm.business.org.local.service.OrgRegionService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventBatchDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventDto;
import com.biz.crm.mdm.business.org.sdk.event.OrgEventListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm
 * @description: 组织与区域关联关系监听组织变更事件
 * @author: Bao Hongbin
 * @create: 2021-12-02 19:45
 **/
@Component
public class OrgEventRegionListenerImpl implements OrgEventListener {
  @Autowired(required = false)
  private OrgRegionService orgRegionService;

  @Override
  public void onDelete(List<String> orgCodes) {
    if (CollectionUtils.isEmpty(orgCodes)) {
      return;
    }
    List<OrgRegion> orgRegions =
        orgRegionService.findByOrgCodes(orgCodes);
    Validate.isTrue(CollectionUtils.isEmpty(orgRegions), "存在组织和区域的关联，无法删除！");
  }

  @Override
  public void onDeleteBatch(OrgEventBatchDto orgEventBatchDto) {

  }

  @Override
  public void onEnableBatch(OrgEventBatchDto orgEventBatchDto) {

  }

  @Override
  public void onDisableBatch(OrgEventBatchDto orgEventBatchDto) {

  }

  @Override
  public void onUpdate(OrgEventDto orgEventDto) {
    //TODO 暂不需要实现
  }
}
