package com.biz.crm.mdm.business.position.level.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 职位级别接口
 *
 * @author ning.zhang
 * @date 2021/9/28
 */
public interface PositionLevelVoService {

  /**
   * 职位级别分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<PositionLevelVo> 职位级别分页信息
   */
  Page<PositionLevelVo> findByConditions(Pageable pageable, PositionLevelDto dto);

  /**
   * 根据id查询编辑职位级别详情
   *
   * @param id 职位级别ID
   * @return 职位级别信息
   */
  PositionLevelVo findById(String id);

  /**
   * 根据职位级别ID集合或者code集合查询职位级别列表
   *
   * @param ids                职位级别ID集合
   * @param positionLevelCodes 职位级别编码集合
   * @return 职位级别列表
   */
  List<PositionLevelVo> findByIdsOrCodes(List<String> ids, List<String> positionLevelCodes);

  /**
   * 通过职位级别编码生成职位名称
   *
   * @param positionLevelCode 职位级别编码
   * @param positionNameSet 职位级别编码对应的职位名称集合
   * @param tenantCode        租户编码
   * @return 职位名称
   */
  String createPositionNameByPositionLevelCode(String positionLevelCode, Set<String> positionNameSet,String tenantCode);
}

