package com.biz.crm.mdm.business.position.level.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 职位级别vo
 *
 * @author ning.zhang
 * @date 2021/9/28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位级别vo")
public class PositionLevelVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 5270764103350255667L;

  /**
   * 职位级别编码
   */
  @ApiModelProperty("职位级别编码")
  private String positionLevelCode;
  /**
   * 职位级别名称
   */
  @ApiModelProperty("职位级别名称")
  private String positionLevelName;
  /**
   * 职位级别生成职位名称后缀增长序列号
   */
  @ApiModelProperty("职位级别生成职位名称后缀增长序列号")
  private Integer suffixSequence;
  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  private String roleCode;
  /**
   * 角色名称
   */
  @ApiModelProperty("角色名称")
  private String roleName;
  /**
   * 关联角色集合
   */
  @ApiModelProperty("关联角色集合")
  private List<String> roleList;
}