package com.biz.crm.mdm.business.product.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.feign.feign.internal.ProductMediaVoServiceFeignImpl;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 商品附件feign
 *
 * @author pengxi
 * @date 2022-09-16 22:30:37
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = ProductMediaVoServiceFeignImpl.class)
public interface ProductMediaVoServiceFeign {

  /**
   * 根据商品编码集合获取对应的媒体信息
   *
   * @param productCodeList 商品编码集合
   */
  @ApiOperation(value = "根据商品编码集合获取对应的媒体信息")
  @GetMapping(value = {"/v1/productMedia/productMedia/findByProductCodes"})
  Result<List<ProductMediaVo>> findByProductCodes(@RequestParam("productCodeList") List<String> productCodeList);
}
