package com.biz.crm.mdm.business.product.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.feign.feign.internal.ProductVoServiceFeignImpl;
import com.biz.crm.mdm.business.product.sdk.dto.*;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 商品feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = ProductVoServiceFeignImpl.class)
public interface ProductVoServiceFeign {

  /**
   * 根据商品商品id集合或编码集合获取商品信息
   *
   * @param ids
   * @param codes
   * @return
   */
  @GetMapping("/v1/product/product/findDetailsByIdsOrCodes")
  Result<List<ProductVo>> findDetailsByIdsOrCodes(
      @RequestParam("ids") List<String> ids, @RequestParam("codes") List<String> codes);

  @PostMapping("/v1/product/product/findProductDetailsByIdsOrCodes")
  Result<List<ProductVo>> findProductDetailsByIdsOrCodes(@RequestBody ProductDetailDto dto);

  /**
   * 根据商品层级获取对应的商品信息
   *
   * @param productLevelCodeList
   * @return
   */
  @GetMapping("/v1/product/product/findByProductLevelCodes")
  Result<List<ProductVo>> findByProductLevelCodes(
      @RequestParam("productLevelCodeList") List<String> productLevelCodeList);

  /**
   * 根据商品商品编码集合获取商品主信息+层级信息
   *
   * @param productCodeList
   * @return
   */
  @GetMapping(value = {"/v1/product/product/findMainDetailsByProductCodes"})
  Result<List<ProductVo>> findMainDetailsByProductCodes(
      @RequestParam("productCodeList") List<String> productCodeList);

  /**
   * 根据ProductQueryDto获取商品主信息
   *
   * @param dto
   * @return
   */
  @GetMapping(value = {"/v1/product/product/findByProductQueryDto"})
  Result<List<ProductVo>> findByProductQueryDto(@SpringQueryMap ProductQueryDto dto);

  /**
   * 根据ProductQueryDto获取商品主信息
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/product/product/findByQueryDto"})
  Result<List<ProductVo>> findByQueryDto(@RequestBody ProductQueryDto dto);

  /**
   * 根据ProductDetailQueryDto获取商品信息
   *
   * @param dto
   * @return
   */
  @GetMapping(value = {"/v1/product/product/findDetailsByProductDetailQueryDto"})
  Result<List<ProductVo>> findDetailsByProductDetailQueryDto(
      @SpringQueryMap ProductDetailQueryDto dto);

  /**
   * 根据层级获取层级及下级所有的上架且启用的产品集合
   *
   * @param productLevelCodes
   * @return
   */
  @GetMapping(value = {"/v1/product/product/findAllowSaleProductByProductLevelCodes"})
  Result<Map<String, String>> findAllowSaleProductByProductLevelCodes(
      @RequestParam("productLevelCodes") Set<String> productLevelCodes);

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/v1/product/product/findPageProductVoByConditions"})
  Result<Page<ProductVo>> findByConditions(
      @PageableDefault(50) Pageable pageable, @SpringQueryMap ProductPaginationDto paginationDto);

  /**
   * 获取商品对应层级及其上级层级编码集合
   *
   * @param productCodeSet
   * @return
   */
  @ApiOperation(value = "获取商品对应层级及其上级层级编码集合")
  @GetMapping(value = {"/v1/product/product/findParentLevelCodeSetByProductCodes"})
  Result<Set<String>> findParentLevelCodeSetByProductCodes(Set<String> productCodeSet);

  @ApiOperation(value = "根据id集合获取商品详情信息")
  @PostMapping(value = "/v1/product/product/findProductByIds")
  Result<List<ProductVo>> findProductByIds(@RequestBody ProductSearchDto dto);
}
