package com.biz.crm.mdm.business.product.level.sdk.dto;
/**
 * Created by Bao Hongbin on 2021-10-08 16:31.
 */

import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @program: crm
 * @description: 产品层级分页查询dto
 * @author: Bao Hongbin
 * @create: 2021-10-08 16:31
 **/
@Data
@ApiModel("产品层级分页查询dto")
public class ProductLevelPaginationDto {


  /**
   * id
   */
  private String id;

  /**
   * 租户编号
   */
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  private String enableStatus;

  /**
   * 备注
   */
  private String remark;

  @ApiModelProperty(name = "createAccount", value = "创建人账号")
  private String createAccount;

  @ApiModelProperty(name = "createName", value = "创建人名称")
  private String createName;

  @ApiModelProperty(name = "createTime", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
  private String modifyAccount;

  @ApiModelProperty(name = "modifyName", value = "更新人名称")
  private String modifyName;

  @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;

  @ApiModelProperty("ID集合")
  private List<String> ids;

  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  @ApiModelProperty("产品层级名称")
  private String productLevelName;

  @ApiModelProperty("产品层级类型")
  private String productLevelType;

  @ApiModelProperty("上级编码")
  private String parentCode;

  @ApiModelProperty("产品层级名称，模糊查询编码或名称")
  private String productLevelCodeOrName;

  @ApiModelProperty("产品层级编码，只查询当前产品层级及下级")
  private String underProductLevelCode;

  @ApiModelProperty("产品层级编码，排除当前层级和下级")
  private String notUnderProductLevelCode;

  @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
  private String selectedCode;

  @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
  private List<String> selectedCodeList;

  /**
   * 产品层级ruleCode，只查询当前产品层级及下级
   */
  @ApiModelProperty("产品层级ruleCode")
  private String ruleCode;
  /**
   * 产品层级ruleCode，只查询当前产品层级及下级
   */
  private String underThisRuleCode;

  /**
   * 产品层级ruleCode，排除当前产品层级及下级
   */
  private String notUnderThisRuleCode;
}
