package com.biz.crm.mdm.business.product.level.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @Description 品项品类关系
 * @Author YangWei
 * @Date 2023/2/13 上午11:43
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "品项品类关系dto")
public class ProductLevelRelationDto extends TenantFlagOpDto {

    /**
     * 上级编码（所属品类编码）
     */
    @ApiModelProperty("上级编码（所属品类编码）")
    private String parentCode;

    /**
     * 产品层级编码（品相编码）
     */
    @ApiModelProperty("产品层级编码（品相编码）")
    private String productLevelCode;


    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;
}