package com.biz.crm.mdm.business.product.level.sdk.enums;

/**
 * 产品层级类型
 *
 * @author Liao.Hua
 * @date 2020-09-01 17:47:01
 */
public enum ProductLevelEnum {

  category("category", "品类"),
  items("items", "品项"),

  max("max", "大类"),
  min("min", "小类"),
  brand("brand", "品牌"),
  series("series", "系列"),
  other("other", "其他");

  /**
   * 编码
   */
  private String code;

  /**
   * 说明
   */
  private String value;

  ProductLevelEnum(String code, String value) {
    this.code = code;
    this.value = value;
  }

  /**
   * 根据code转枚举
   *
   * @param code
   * @return
   */
  public static ProductLevelEnum codeToEnum(String code) {
    ProductLevelEnum result = null;
    for (ProductLevelEnum productLevelEnum : ProductLevelEnum.values()) {
      if (productLevelEnum.code.equals(code)) {
        result = productLevelEnum;
      }
    }
    return result;
  }

  public String getCode() {
    return code;
  }

  public String getValue() {
    return value;
  }
}
